/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import mekanism.api.Upgrade;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.common.MekanismLang;
import mekanism.common.lib.Color;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiSupportedUpgrades
extends GuiElement {
    private static final int ELEMENT_SIZE = 12;
    private static final int FIRST_ROW_ROOM = 5;
    private static final int ROW_ROOM = 10;
    private final Set<Upgrade> supportedUpgrades;
    private List<Component> lastInfo = Collections.emptyList();
    @Nullable
    private Tooltip lastTooltip;
    @Nullable
    private ScreenRectangle cachedTooltipRect;

    public static int calculateNeededRows() {
        int count = EnumUtils.UPGRADES.length;
        if (count <= 5) {
            return 1;
        }
        return 2 + (count -= 5) / 10;
    }

    public GuiSupportedUpgrades(IGuiWrapper gui, int x, int y, Set<Upgrade> supportedUpgrades) {
        super(gui, x, y, 125, 12 * GuiSupportedUpgrades.calculateNeededRows() + 2);
        this.supportedUpgrades = supportedUpgrades;
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderBackgroundTexture(guiGraphics, GuiElementHolder.HOLDER, 32, 32);
        int backgroundColor = Color.argb(GuiElementHolder.getBackgroundColor()).alpha(0.5).argb();
        for (int i = 0; i < EnumUtils.UPGRADES.length; ++i) {
            Upgrade upgrade = EnumUtils.UPGRADES[i];
            UpgradePos pos = this.getUpgradePos(i);
            int xPos = this.relativeX + 1 + pos.x;
            int yPos = this.relativeY + 1 + pos.y;
            this.gui().renderItem(guiGraphics, UpgradeUtils.getStack(upgrade), xPos, yPos, 0.75f);
            if (this.supportedUpgrades.contains(upgrade)) continue;
            guiGraphics.fill(RenderType.guiGhostRecipeOverlay(), xPos, yPos, xPos + 12, yPos + 12, backgroundColor);
        }
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        this.drawTextScaledBound(guiGraphics, (Component)MekanismLang.UPGRADES_SUPPORTED.translate(), this.relativeX + 2, this.relativeY + 3, this.titleTextColor(), 54.0f);
    }

    @Override
    @NotNull
    protected ScreenRectangle getTooltipRectangle(int mouseX, int mouseY) {
        return this.cachedTooltipRect == null ? super.getTooltipRectangle(mouseX, mouseY) : this.cachedTooltipRect;
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        for (int i = 0; i < EnumUtils.UPGRADES.length; ++i) {
            UpgradePos pos = this.getUpgradePos(i);
            if (mouseX < this.getX() + 1 + pos.x || mouseX >= this.getX() + 1 + pos.x + 12 || mouseY < this.getY() + 1 + pos.y || mouseY >= this.getY() + 1 + pos.y + 12) continue;
            Upgrade upgrade = EnumUtils.UPGRADES[i];
            MutableComponent upgradeName = MekanismLang.UPGRADE_TYPE.translateColored(EnumColor.YELLOW, upgrade);
            List<Component> info = this.supportedUpgrades.contains(upgrade) ? List.of(upgradeName, upgrade.getDescription()) : List.of(MekanismLang.UPGRADE_NOT_SUPPORTED.translateColored(EnumColor.RED, upgradeName), upgrade.getDescription());
            if (!info.equals(this.lastInfo)) {
                this.lastInfo = info;
                this.lastTooltip = TooltipUtils.create(info);
                this.cachedTooltipRect = new ScreenRectangle(this.getX() + 1 + pos.x, this.getY() + 1 + pos.y, 12, 12);
            }
            this.setTooltip(this.lastTooltip);
            return;
        }
        this.lastInfo = Collections.emptyList();
        this.cachedTooltipRect = null;
        this.lastTooltip = null;
        this.setTooltip(null);
    }

    private UpgradePos getUpgradePos(int index) {
        int row;
        int n = row = index < 5 ? 0 : 1 + (index - 5) / 10;
        if (row == 0) {
            return new UpgradePos(55 + index % 5 * 12, 0);
        }
        return new UpgradePos((index -= 5) % 10 * 12, row * 12);
    }

    private record UpgradePos(int x, int y) {
    }
}

