/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom.module;

import java.util.List;
import mekanism.api.gear.config.IHasModeIcon;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.text.IHasTextComponent;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.element.custom.module.GuiModuleScreen;
import mekanism.client.gui.element.custom.module.MiniElement;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.ModuleConfigItem;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

class EnumToggle<TYPE extends Enum<TYPE>>
extends MiniElement {
    private static final ResourceLocation SLIDER = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "slider.png");
    private static final float TEXT_SCALE = 0.7f;
    private static final int BAR_START = 10;
    private final int BAR_LENGTH;
    private final ModuleConfigItem<TYPE> data;
    private final int optionDistance;
    private final boolean usesIcons;
    boolean dragging = false;

    EnumToggle(GuiModuleScreen parent, ModuleConfigItem<TYPE> data, int xPos, int yPos) {
        super(parent, xPos, yPos);
        this.data = data;
        this.BAR_LENGTH = this.parent.getScreenWidth() - 24;
        List<TYPE> options = this.getData().getEnums();
        this.optionDistance = this.BAR_LENGTH / (options.size() - 1);
        this.usesIcons = options.stream().findFirst().filter(option -> option instanceof IHasModeIcon).isPresent();
    }

    @Override
    protected int getNeededHeight() {
        return this.usesIcons ? 31 : 28;
    }

    private ModuleEnumData<TYPE> getData() {
        return (ModuleEnumData)this.data.getData();
    }

    @Override
    protected void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int center = this.optionDistance * ((Enum)this.data.get()).ordinal();
        guiGraphics.blit(SLIDER, this.getRelativeX() + 10 + center - 2, this.getRelativeY() + 11, 0.0f, 0.0f, 5, 6, 8, 8);
        guiGraphics.blit(SLIDER, this.getRelativeX() + 10, this.getRelativeY() + 17, 0.0f, 6.0f, this.BAR_LENGTH, 2, 8, 8);
    }

    @Override
    protected void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int textColor = this.parent.screenTextColor();
        Component description = this.data.getDescription();
        if (this.usesIcons) {
            description = MekanismLang.GENERIC_STORED.translate(description, this.getData().get());
        }
        this.parent.drawScaledTextScaledBound(guiGraphics, description, this.getRelativeX() + 3, this.getRelativeY(), textColor, this.parent.getScreenWidth() - 3 - 6, 0.8f);
        List<TYPE> options = this.getData().getEnums();
        int count = options.size();
        for (int i = 0; i < count; ++i) {
            int center = this.optionDistance * i;
            Enum option = (Enum)options.get(i);
            Component text = ((IHasTextComponent)((Object)option)).getTextComponent();
            int textWidth = this.parent.getStringWidth(text);
            int optionCenter = 10 + center;
            float widthScaling = this.usesIcons ? 2.5f : (float)textWidth / 2.0f * 0.7f;
            float left = (float)optionCenter - widthScaling;
            if (left < 0.0f) {
                left = 0.0f;
            } else {
                int max = this.parent.getScreenWidth() - 1;
                float objectWidth = this.usesIcons ? 5.0f : (float)textWidth * 0.7f;
                int end = this.xPos + Mth.ceil((float)(left + objectWidth));
                if (end > max) {
                    left -= (float)(end - max);
                }
            }
            int color = textColor;
            if (text.getStyle().getColor() != null) {
                color = 0xFF000000 | text.getStyle().getColor().getValue();
            }
            GuiUtils.fill(guiGraphics, this.getRelativeX() + optionCenter, this.getRelativeY() + 17, 1, 3, color);
            if (this.usesIcons) {
                IHasModeIcon hasModeIcon = (IHasModeIcon)((Object)option);
                guiGraphics.blit(hasModeIcon.getModeIcon(), this.getRelativeX() + optionCenter - 8, this.getRelativeY() + 19, 0.0f, 0.0f, 16, 16, 16, 16);
                continue;
            }
            this.parent.drawTextWithScale(guiGraphics, text, (float)this.getRelativeX() + left, this.getRelativeY() + 20, textColor, 0.7f);
        }
    }

    @Override
    protected void click(double mouseX, double mouseY) {
        if (!this.dragging) {
            int center = this.optionDistance * ((Enum)this.data.get()).ordinal();
            if (this.mouseOver(mouseX, mouseY, 10 + center - 2, 11, 5, 6)) {
                this.dragging = true;
            } else if (this.mouseOver(mouseX, mouseY, 10, 10, this.BAR_LENGTH, 12)) {
                this.setData(this.getData().getEnums(), mouseX);
            }
        }
    }

    @Override
    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.dragging) {
            this.setData(this.getData().getEnums(), mouseX);
        }
    }

    private void setData(List<TYPE> options, double mouseX) {
        int size = options.size() - 1;
        int cur = (int)Math.round((mouseX - (double)this.getX() - 10.0) / (double)this.BAR_LENGTH * (double)size);
        if ((cur = Mth.clamp((int)cur, (int)0, (int)size)) != ((Enum)this.data.get()).ordinal()) {
            this.setData(this.data, (Enum)options.get(cur));
        }
    }

    @Override
    protected void release(double mouseX, double mouseY) {
        this.dragging = false;
    }
}

