/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.gauge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.gauge.GaugeInfo;
import mekanism.client.gui.element.gauge.GaugeOverlay;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.warning.ISupportsWarning;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GuiGauge<T>
extends GuiTexturedElement
implements ISupportsWarning<GuiGauge<T>> {
    private final GaugeType gaugeType;
    protected boolean dummy;
    protected T dummyType;
    @Nullable
    private BooleanSupplier warningSupplier;
    private List<Component> lastInfo = Collections.emptyList();
    @Nullable
    private Tooltip lastTooltip;

    public GuiGauge(GaugeType gaugeType, IGuiWrapper gui, int x, int y) {
        this(gaugeType, gui, x, y, gaugeType.getGaugeOverlay().getWidth() + 2, gaugeType.getGaugeOverlay().getHeight() + 2);
    }

    public GuiGauge(GaugeType gaugeType, IGuiWrapper gui, int x, int y, int sizeX, int sizeY) {
        super(gaugeType.getGaugeOverlay().getBarOverlay(), gui, x, y, sizeX, sizeY);
        this.gaugeType = gaugeType;
    }

    @Override
    public GuiGauge<T> warning(@NotNull WarningTracker.WarningType type, @NotNull BooleanSupplier warningSupplier) {
        this.warningSupplier = ISupportsWarning.compound(this.warningSupplier, this.gui().trackWarning(type, warningSupplier));
        return this;
    }

    public abstract int getScaledLevel();

    @Nullable
    public abstract TextureAtlasSprite getIcon();

    public abstract Component getLabel();

    public abstract List<Component> getTooltipText();

    public GaugeOverlay getGaugeOverlay() {
        return this.gaugeType.getGaugeOverlay();
    }

    protected GaugeInfo getGaugeColor() {
        return this.gaugeType.getGaugeInfo();
    }

    protected void applyRenderColor(GuiGraphics guiGraphics) {
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        GaugeInfo color = this.getGaugeColor();
        this.renderExtendedTexture(guiGraphics, color.getResourceLocation(), color.getSideWidth(), color.getSideHeight());
        if (!this.dummy) {
            this.renderContents(guiGraphics);
        }
    }

    public void renderContents(GuiGraphics guiGraphics) {
        boolean warning;
        boolean bl = warning = this.warningSupplier != null && this.warningSupplier.getAsBoolean();
        if (warning) {
            guiGraphics.blit(GuiSlot.WARNING_BACKGROUND_TEXTURE, this.relativeX + 1, this.relativeY + 1, 0.0f, 0.0f, this.width - 2, this.height - 2, 256, 256);
        }
        int scale = this.getScaledLevel();
        TextureAtlasSprite icon = this.getIcon();
        if (scale > 0 && icon != null) {
            this.applyRenderColor(guiGraphics);
            this.drawTiledSprite(guiGraphics, this.relativeX + 1, this.relativeY + 1, this.height - 2, this.width - 2, scale, icon, GuiUtils.TilingDirection.UP_RIGHT);
            MekanismRenderer.resetColor(guiGraphics);
            if (warning && (double)scale / (double)(this.height - 2) > 0.98) {
                int halfWidth = (this.width - 2) / 2;
                guiGraphics.blit(WARNING_TEXTURE, this.relativeX + 1 + halfWidth, this.relativeY + 1, (float)halfWidth, 0.0f, halfWidth, this.height - 2, 256, 256);
            }
        }
        this.drawBarOverlay(guiGraphics);
    }

    public void drawBarOverlay(GuiGraphics guiGraphics) {
        GaugeOverlay gaugeOverlay = this.getGaugeOverlay();
        guiGraphics.blit(this.getResource(), this.relativeX + 1, this.relativeY + 1, this.getWidth() - 2, this.getHeight() - 2, 0.0f, 0.0f, gaugeOverlay.getWidth(), gaugeOverlay.getHeight(), gaugeOverlay.getWidth(), gaugeOverlay.getHeight());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        block8: {
            block7: {
                if (this.dummy) {
                    return;
                }
                stack = this.gui().getCarriedItem();
                color = this.getGaugeColor().getColor();
                if (stack.isEmpty() || !(stack.getItem() instanceof ItemConfigurator) || color == null) break block7;
                var8_5 /* !! */  = this.gui();
                if (!(var8_5 /* !! */  instanceof GuiMekanismTile) || !((var8_5 /* !! */  = (gui = (GuiMekanismTile)var8_5 /* !! */ ).getTileEntity()) instanceof ISideConfiguration)) ** GOTO lbl-1000
                sideConfig = (ISideConfiguration)var8_5 /* !! */ ;
                if (this.getTransmission() != null) {
                    dataType = null;
                    config = sideConfig.getConfig().getConfig(this.getTransmission());
                    if (config != null) {
                        for (DataType type : config.getSupportedDataTypes()) {
                            if (type.getColor() != color) continue;
                            dataType = type;
                            break;
                        }
                    }
                    list /* !! */  = dataType == null ? List.of(MekanismLang.GENERIC_PARENTHESIS.translateColored(color, new Object[]{color.getName()})) : List.of(MekanismLang.GENERIC_WITH_PARENTHESIS.translateColored(color, new Object[]{dataType, color.getName()}));
                } else lbl-1000:
                // 2 sources

                {
                    list /* !! */  = Collections.emptyList();
                }
                break block8;
            }
            list /* !! */  = new ArrayList<Component>(this.getTooltipText());
            if (this.getLabel() != null) {
                list /* !! */ .add(0, this.getLabel());
            }
        }
        if (!list /* !! */ .equals(this.lastInfo)) {
            this.lastInfo = list /* !! */ ;
            this.lastTooltip = TooltipUtils.create(list /* !! */ );
        }
        this.setTooltip(this.lastTooltip);
    }

    @Nullable
    public abstract TransmissionType getTransmission();

    public void setDummyType(T type) {
        this.dummyType = type;
    }
}

