/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.progress;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.BooleanSupplier;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.progress.IProgressInfoHandler;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.recipe_viewer.interfaces.IRecipeViewerRecipeArea;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.inventory.warning.ISupportsWarning;
import mekanism.common.inventory.warning.WarningTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class GuiProgress
extends GuiTexturedElement
implements IRecipeViewerRecipeArea<GuiProgress>,
ISupportsWarning<GuiProgress> {
    protected final IProgressInfoHandler handler;
    protected final ProgressType type;
    private IRecipeViewerRecipeType<?>[] recipeCategories;
    @Nullable
    private ColorDetails colorDetails;
    @Nullable
    private BooleanSupplier warningSupplier;

    public GuiProgress(IProgressInfoHandler.IBooleanProgressInfoHandler handler, ProgressType type, IGuiWrapper gui, int x, int y) {
        this((IProgressInfoHandler)handler, type, gui, x, y);
    }

    public GuiProgress(IProgressInfoHandler handler, ProgressType type, IGuiWrapper gui, int x, int y) {
        super(type.getTexture(), gui, x, y, type.getWidth(), type.getHeight());
        this.type = type;
        this.handler = handler;
    }

    public GuiProgress colored(ColorDetails colorDetails) {
        this.colorDetails = colorDetails;
        return this;
    }

    @Override
    public GuiProgress warning(@NotNull WarningTracker.WarningType type, @NotNull BooleanSupplier warningSupplier) {
        this.warningSupplier = ISupportsWarning.compound(this.warningSupplier, this.gui().trackWarning(type, warningSupplier));
        return this;
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.handler.isActive()) {
            double progress;
            ResourceLocation resource = this.getResource();
            guiGraphics.blit(resource, this.relativeX, this.relativeY, 0.0f, 0.0f, this.width, this.height, this.type.getTextureWidth(), this.type.getTextureHeight());
            boolean warning = this.warningSupplier != null && this.warningSupplier.getAsBoolean();
            double d = progress = warning ? 1.0 : this.getProgress();
            if (this.type.isVertical()) {
                int displayInt = (int)(progress * (double)this.height);
                if (displayInt > 0) {
                    int innerOffsetY = 0;
                    if (this.type.isReverse()) {
                        innerOffsetY += this.type.getTextureHeight() - displayInt;
                    }
                    this.blit(guiGraphics, resource, this.relativeX, this.relativeY + innerOffsetY, this.type.getOverlayX(warning), this.type.getOverlayY(warning) + innerOffsetY, this.width, displayInt, this.type.getTextureWidth(), this.type.getTextureHeight(), progress, warning);
                }
            } else {
                int innerOffsetX = this.type == ProgressType.BAR ? 1 : 0;
                int displayInt = (int)(progress * (double)(this.width - 2 * innerOffsetX));
                if (displayInt > 0) {
                    if (this.type.isReverse()) {
                        innerOffsetX += this.type.getTextureWidth() - displayInt;
                    }
                    this.blit(guiGraphics, resource, this.relativeX + innerOffsetX, this.relativeY, this.type.getOverlayX(warning) + innerOffsetX, this.type.getOverlayY(warning), displayInt, this.height, this.type.getTextureWidth(), this.type.getTextureHeight(), progress, warning);
                }
            }
        }
    }

    protected double getProgress() {
        return Math.min(this.handler.getProgress(), 1.0);
    }

    @Override
    public boolean isRecipeViewerAreaActive() {
        return this.handler.isActive();
    }

    @Override
    @NotNull
    public GuiProgress recipeViewerCategories(IRecipeViewerRecipeType<?> ... recipeCategories) {
        this.recipeCategories = recipeCategories;
        return this;
    }

    @Override
    @Nullable
    public IRecipeViewerRecipeType<?>[] getRecipeCategories() {
        return this.recipeCategories;
    }

    private void blit(GuiGraphics guiGraphics, ResourceLocation resource, int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight, double progress, boolean warning) {
        if (warning || this.colorDetails == null) {
            guiGraphics.blit(resource, x, y, uOffset, vOffset, width, height, textureWidth, textureHeight);
            return;
        }
        int colorFrom = this.colorDetails.getColorFrom();
        int colorTo = this.colorDetails.getColorTo();
        if (colorFrom == -1 && colorTo == -1) {
            guiGraphics.blit(resource, x, y, uOffset, vOffset, width, height, textureWidth, textureHeight);
            return;
        }
        int x2 = x + width;
        int y2 = y + height;
        Matrix4f matrix = guiGraphics.pose().last().pose();
        float minU = uOffset / (float)textureWidth;
        float maxU = (uOffset + (float)width) / (float)textureWidth;
        float minV = vOffset / (float)textureHeight;
        float maxV = (vOffset + (float)height) / (float)textureHeight;
        float alphaFrom = MekanismRenderer.getAlpha(colorFrom);
        float redFrom = MekanismRenderer.getRed(colorFrom);
        float greenFrom = MekanismRenderer.getGreen(colorFrom);
        float blueFrom = MekanismRenderer.getBlue(colorFrom);
        float alphaTo = MekanismRenderer.getAlpha(colorTo);
        float redTo = MekanismRenderer.getRed(colorTo);
        float greenTo = MekanismRenderer.getGreen(colorTo);
        float blueTo = MekanismRenderer.getBlue(colorTo);
        float percent = (float)progress;
        alphaTo = alphaFrom + percent * (alphaTo - alphaFrom);
        redTo = redFrom + percent * (redTo - redFrom);
        greenTo = greenFrom + percent * (greenTo - greenFrom);
        blueTo = blueFrom + percent * (blueTo - blueFrom);
        if (this.type.isReverse()) {
            float alphaTemp = alphaTo;
            float redTemp = redTo;
            float greenTemp = greenTo;
            float blueTemp = blueTo;
            alphaTo = alphaFrom;
            redTo = redFrom;
            greenTo = greenFrom;
            blueTo = blueFrom;
            alphaFrom = alphaTemp;
            redFrom = redTemp;
            greenFrom = greenTemp;
            blueFrom = blueTemp;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resource);
        RenderSystem.setShader(GameRenderer::getPositionColorTexShader);
        BufferBuilder builder = Tesselator.getInstance().getBuilder();
        builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX);
        if (this.type.isVertical()) {
            builder.vertex(matrix, (float)x, (float)y2, 0.0f).color(redTo, greenTo, blueTo, alphaTo).uv(minU, maxV).endVertex();
            builder.vertex(matrix, (float)x2, (float)y2, 0.0f).color(redTo, greenTo, blueTo, alphaTo).uv(maxU, maxV).endVertex();
            builder.vertex(matrix, (float)x2, (float)y, 0.0f).color(redFrom, greenFrom, blueFrom, alphaFrom).uv(maxU, minV).endVertex();
            builder.vertex(matrix, (float)x, (float)y, 0.0f).color(redFrom, greenFrom, blueFrom, alphaFrom).uv(minU, minV).endVertex();
        } else {
            builder.vertex(matrix, (float)x, (float)y2, 0.0f).color(redFrom, greenFrom, blueFrom, alphaFrom).uv(minU, maxV).endVertex();
            builder.vertex(matrix, (float)x2, (float)y2, 0.0f).color(redTo, greenTo, blueTo, alphaTo).uv(maxU, maxV).endVertex();
            builder.vertex(matrix, (float)x2, (float)y, 0.0f).color(redTo, greenTo, blueTo, alphaTo).uv(maxU, minV).endVertex();
            builder.vertex(matrix, (float)x, (float)y, 0.0f).color(redFrom, greenFrom, blueFrom, alphaFrom).uv(minU, minV).endVertex();
        }
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)builder.end());
        RenderSystem.disableBlend();
    }

    public static interface ColorDetails {
        public int getColorFrom();

        public int getColorTo();
    }
}

