/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import mekanism.api.gear.IModule;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.scroll.GuiScrollList;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.ModuleContainer;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiModuleScrollList
extends GuiScrollList {
    private static final ResourceLocation MODULE_SELECTION = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "module_selection.png");
    private static final int TEXTURE_WIDTH = 100;
    private static final int TEXTURE_HEIGHT = 36;
    private final Consumer<Module<?>> callback;
    private final List<ModuleData<?>> currentList = new ArrayList();
    private final Supplier<ItemStack> itemSupplier;
    private ItemStack currentItem;
    @Nullable
    private ModuleContainer currentContainer;
    @Nullable
    private ModuleData<?> selected;
    @Nullable
    private Component lastInfo = null;
    @Nullable
    private Tooltip lastTooltip;
    @Nullable
    private ScreenRectangle cachedTooltipRect;

    public GuiModuleScrollList(IGuiWrapper gui, int x, int y, int width, int height, Supplier<ItemStack> itemSupplier, Consumer<Module<?>> callback) {
        super(gui, x, y, width, height, 12, GuiElementHolder.HOLDER, 32);
        this.itemSupplier = itemSupplier;
        this.callback = callback;
        this.updateItemAndList(itemSupplier.get());
    }

    public void updateItemAndList(ItemStack stack) {
        this.currentItem = stack;
        this.currentContainer = ModuleHelper.get().getModuleContainerNullable(stack);
        this.currentList.clear();
        if (this.currentContainer != null) {
            this.currentList.addAll(this.currentContainer.moduleTypes());
        }
    }

    private void recheckItem() {
        ItemStack stack = this.itemSupplier.get();
        if (!ItemStack.matches((ItemStack)this.currentItem, (ItemStack)stack)) {
            this.updateItemAndList(stack);
            ModuleData<?> prevSelect = this.getSelection();
            if (prevSelect != null) {
                if (this.currentList.contains(prevSelect)) {
                    this.onSelectedChange();
                } else {
                    this.clearSelection();
                }
            }
        }
    }

    @Override
    protected int getMaxElements() {
        return this.currentList.size();
    }

    @Override
    public boolean hasSelection() {
        return this.selected != null;
    }

    @Override
    protected void setSelected(int index) {
        if (index >= 0 && index < this.currentList.size()) {
            this.setSelected(this.currentList.get(index));
        }
    }

    private void setSelected(@Nullable ModuleData<?> newData) {
        if (this.selected != newData) {
            this.selected = newData;
            this.onSelectedChange();
        }
    }

    private void onSelectedChange() {
        if (this.selected == null || this.currentContainer == null) {
            this.callback.accept(null);
        } else {
            this.callback.accept((Module<?>)this.currentContainer.get((IModuleDataProvider)this.selected));
        }
    }

    @Nullable
    public ModuleData<?> getSelection() {
        return this.selected;
    }

    @Override
    public void clearSelection() {
        this.setSelected(null);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        this.recheckItem();
        this.forEachModule((module, multipliedElement) -> {
            IModule instance;
            if (this.currentContainer != null && (instance = this.currentContainer.get((IModuleDataProvider)module)) != null) {
                boolean enabled = instance.isEnabled();
                int color = module.isExclusive(-1) ? (enabled ? 6511572 : 3025513) : (enabled ? this.titleTextColor() : 6167837);
                this.drawScaledTextScaledBound(guiGraphics, (Component)TextComponentUtil.build(module), this.relativeX + 13, this.relativeY + 3 + multipliedElement, color, 86.0f, 0.7f);
            }
        });
    }

    @Override
    @NotNull
    protected ScreenRectangle getTooltipRectangle(int mouseX, int mouseY) {
        return this.cachedTooltipRect == null ? super.getTooltipRectangle(mouseX, mouseY) : this.cachedTooltipRect;
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        if (this.currentContainer != null && mouseX >= this.getX() + 1 && mouseX < this.getX() + this.barXShift - 1) {
            int index;
            for (int i = 0; i < this.getFocusedElements() && (index = this.getCurrentSelection() + i) <= this.currentList.size() - 1; ++i) {
                ModuleData<?> module = this.currentList.get(index);
                int installed = this.currentContainer.installedCount(module);
                int multipliedElement = this.elementHeight * i;
                if (installed <= 0 || mouseY < this.getY() + 1 + multipliedElement || mouseY >= this.getY() + 1 + multipliedElement + this.elementHeight) continue;
                MutableComponent info = MekanismLang.MODULE_INSTALLED.translate(MekanismLang.GENERIC_FRACTION.translateColored(EnumColor.GRAY, installed, module.getMaxStackSize()));
                if (!info.equals(this.lastInfo)) {
                    this.lastInfo = info;
                    this.lastTooltip = TooltipUtils.create((Component)info);
                }
                this.cachedTooltipRect = new ScreenRectangle(this.getX() + 1, this.getY() + 1 + multipliedElement, this.barXShift - 2, this.elementHeight);
                this.setTooltip(this.lastTooltip);
                return;
            }
        }
        this.cachedTooltipRect = null;
        this.lastInfo = null;
        this.lastTooltip = null;
        this.setTooltip(null);
    }

    @Override
    public void renderElements(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.forEachModule((module, multipliedElement) -> {
            int shiftedY = this.getY() + 1 + multipliedElement;
            int j = 1;
            if (module == this.getSelection()) {
                j = 2;
            } else if (mouseX >= this.getX() + 1 && mouseX < this.getX() + this.barXShift - 1 && mouseY >= shiftedY && mouseY < shiftedY + this.elementHeight) {
                j = 0;
            }
            guiGraphics.blit(MODULE_SELECTION, this.relativeX + 1, this.relativeY + 1 + multipliedElement, 0.0f, (float)(this.elementHeight * j), 100, this.elementHeight, 100, 36);
        });
        this.forEachModule((module, multipliedElement) -> this.gui().renderItem(guiGraphics, module.getItemProvider().getItemStack(), this.relativeX + 3, this.relativeY + 3 + multipliedElement, 0.5f));
    }

    private void forEachModule(ObjIntConsumer<ModuleData<?>> consumer) {
        int index;
        for (int i = 0; i < this.getFocusedElements() && (index = this.getCurrentSelection() + i) <= this.currentList.size() - 1; ++i) {
            consumer.accept(this.currentList.get(index), this.elementHeight * i);
        }
    }

    @Override
    public void syncFrom(GuiElement element) {
        super.syncFrom(element);
        GuiModuleScrollList old = (GuiModuleScrollList)element;
        if (ItemStack.matches((ItemStack)this.currentItem, (ItemStack)old.currentItem)) {
            this.selected = old.selected;
        } else if (old.selected != null) {
            if (this.currentList.contains(old.selected)) {
                this.setSelected(old.selected);
            } else {
                this.onSelectedChange();
            }
        }
    }
}

