/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.security.IBlockSecurityUtils;
import mekanism.api.security.IEntitySecurityUtils;
import mekanism.api.security.IItemSecurityUtils;
import mekanism.api.security.IOwnerObject;
import mekanism.api.security.ISecurityObject;
import mekanism.api.security.ISecurityUtils;
import mekanism.api.security.ITypedSecurityUtils;
import mekanism.api.security.SecurityMode;
import mekanism.api.text.EnumColor;
import mekanism.client.SpecialColors;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInsetElement;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.lib.security.SecurityData;
import mekanism.common.lib.security.SecurityUtils;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.network.to_server.PacketItemGuiInteract;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiSecurityTab
extends GuiInsetElement<SecurityInfoProvider<?>> {
    private static final ResourceLocation PUBLIC = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "public.png");
    private static final ResourceLocation PRIVATE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "private.png");
    private static final ResourceLocation PROTECTED = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "protected.png");
    @Nullable
    private final InteractionHand currentHand;
    private List<Component> lastInfo = Collections.emptyList();
    @Nullable
    private Tooltip lastTooltip;

    public GuiSecurityTab(IGuiWrapper gui, BlockEntity tile) {
        this(gui, tile, 34);
    }

    public GuiSecurityTab(IGuiWrapper gui, BlockEntity tile, int y) {
        this(gui, SecurityInfoProvider.create(tile), y, null);
    }

    public GuiSecurityTab(IGuiWrapper gui, Entity entity, int y) {
        this(gui, new SecurityInfoProvider<Entity>(IEntitySecurityUtils.INSTANCE, () -> entity), y);
    }

    public GuiSecurityTab(IGuiWrapper gui, SecurityInfoProvider<?> provider, int y) {
        this(gui, provider, y, null);
    }

    public GuiSecurityTab(IGuiWrapper gui, @NotNull InteractionHand hand) {
        this(gui, new SecurityInfoProvider<ItemStack>(IItemSecurityUtils.INSTANCE, () -> GuiSecurityTab.minecraft.player.getItemInHand(hand)), 34, hand);
    }

    private GuiSecurityTab(IGuiWrapper gui, SecurityInfoProvider<?> provider, int y, @Nullable InteractionHand hand) {
        super(PUBLIC, gui, provider, gui.getXSize(), y, 26, 18, false);
        this.currentHand = hand;
    }

    @Override
    protected void colorTab(GuiGraphics guiGraphics) {
        MekanismRenderer.color(guiGraphics, SpecialColors.TAB_SECURITY);
    }

    @Override
    protected ResourceLocation getOverlay() {
        return switch (((SecurityInfoProvider)this.dataSource).securityMode()) {
            default -> throw new IncompatibleClassChangeError();
            case SecurityMode.PUBLIC -> super.getOverlay();
            case SecurityMode.PRIVATE -> PRIVATE;
            case SecurityMode.TRUSTED -> PROTECTED;
        };
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        ISecurityObject security = ((SecurityInfoProvider)this.dataSource).securityObject();
        if (security != null) {
            SecurityData data = SecurityUtils.get().getFinalData(security, true);
            ArrayList<Component> info = new ArrayList<Component>(3);
            info.add((Component)MekanismLang.SECURITY.translateColored(EnumColor.GRAY, data.mode()));
            info.add(OwnerDisplay.of((Player)GuiSecurityTab.minecraft.player, security.getOwnerUUID(), security.getOwnerName()).getTextComponent());
            if (data.override()) {
                info.add((Component)MekanismLang.SECURITY_OVERRIDDEN.translateColored(EnumColor.RED));
            }
            if (!info.equals(this.lastInfo)) {
                this.lastInfo = info;
                this.lastTooltip = TooltipUtils.create(info);
            }
        } else {
            this.lastTooltip = null;
            this.lastInfo = Collections.emptyList();
        }
        this.setTooltip(this.lastTooltip);
    }

    public void onClick(double mouseX, double mouseY, int button) {
        ISecurityObject security = ((SecurityInfoProvider)this.dataSource).securityObject();
        if (security != null && security.ownerMatches((Player)GuiSecurityTab.minecraft.player)) {
            if (this.currentHand != null) {
                PacketUtils.sendToServer(new PacketItemGuiInteract(button == 0 ? PacketItemGuiInteract.ItemGuiInteraction.NEXT_SECURITY_MODE : PacketItemGuiInteract.ItemGuiInteraction.PREVIOUS_SECURITY_MODE, this.currentHand));
            } else {
                Object provider = ((SecurityInfoProvider)this.dataSource).objectSupplier.get();
                if (provider instanceof BlockEntity) {
                    BlockEntity tile = (BlockEntity)provider;
                    PacketUtils.sendToServer(new PacketGuiInteract(button == 0 ? PacketGuiInteract.GuiInteraction.NEXT_SECURITY_MODE : PacketGuiInteract.GuiInteraction.PREVIOUS_SECURITY_MODE, tile));
                } else if (provider instanceof Entity) {
                    Entity entity = (Entity)provider;
                    PacketUtils.sendToServer(new PacketGuiInteract(button == 0 ? PacketGuiInteract.GuiInteractionEntity.NEXT_SECURITY_MODE : PacketGuiInteract.GuiInteractionEntity.PREVIOUS_SECURITY_MODE, entity));
                }
            }
        }
    }

    public boolean isValidClickButton(int button) {
        return button == 0 || button == 1;
    }

    public record SecurityInfoProvider<OBJECT>(Supplier<OBJECT> objectSupplier, Function<OBJECT, @Nullable ISecurityObject> securityProvider, Function<OBJECT, @Nullable IOwnerObject> ownerProvider) {
        public SecurityInfoProvider(ITypedSecurityUtils<OBJECT> securityUtils, Supplier<OBJECT> objectSupplier) {
            this(objectSupplier, securityUtils::securityCapability, securityUtils::ownerCapability);
        }

        public static SecurityInfoProvider<BlockEntity> create(BlockEntity tile) {
            return new SecurityInfoProvider<BlockEntity>(() -> tile, t -> {
                if (t.getLevel() == null) {
                    return null;
                }
                return IBlockSecurityUtils.INSTANCE.securityCapability(t.getLevel(), t.getBlockPos(), (BlockEntity)t);
            }, t -> {
                if (t.getLevel() == null) {
                    return null;
                }
                return IBlockSecurityUtils.INSTANCE.ownerCapability(t.getLevel(), t.getBlockPos(), (BlockEntity)t);
            });
        }

        @Nullable
        public ISecurityObject securityObject() {
            return this.securityProvider.apply(this.objectSupplier.get());
        }

        SecurityMode securityMode() {
            OBJECT object = this.objectSupplier.get();
            return ISecurityUtils.INSTANCE.getSecurityMode(object, this.securityProvider, this.ownerProvider, true);
        }
    }
}

