/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiColorPickerSlot;
import mekanism.client.gui.element.GuiScreenSwitch;
import mekanism.client.gui.element.GuiSlider;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.HUDElement;
import mekanism.common.inventory.container.SelectedWindowData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class GuiMekaSuitHelmetOptions
extends GuiWindow {
    public GuiMekaSuitHelmetOptions(IGuiWrapper gui, int x, int y) {
        super(gui, x, y, 140, 140, SelectedWindowData.WindowType.MEKA_SUIT_HELMET);
        this.interactionStrategy = GuiWindow.InteractionStrategy.NONE;
        this.addChild(new GuiColorPickerSlot(gui, this.relativeX + 12, this.relativeY + 32, false, HUDElement.HUDColor.REGULAR::getColor, color -> {
            MekanismConfig.client.hudColor.set(color.rgb());
            MekanismConfig.client.save();
        }));
        this.addChild(new GuiColorPickerSlot(gui, this.relativeX + 61, this.relativeY + 32, false, HUDElement.HUDColor.WARNING::getColor, color -> {
            MekanismConfig.client.hudWarningColor.set(color.rgb());
            MekanismConfig.client.save();
        }));
        this.addChild(new GuiColorPickerSlot(gui, this.relativeX + 110, this.relativeY + 32, false, HUDElement.HUDColor.DANGER::getColor, color -> {
            MekanismConfig.client.hudDangerColor.set(color.rgb());
            MekanismConfig.client.save();
        }));
        GuiSlider opacitySlider = this.addChild(new GuiSlider(gui, this.relativeX + 10, this.relativeY + 62, 120, value -> {
            MekanismConfig.client.hudOpacity.set(value);
            MekanismConfig.client.save();
        }));
        opacitySlider.setValue(MekanismConfig.client.hudOpacity.get());
        GuiSlider jitterSlider = this.addChild(new GuiSlider(gui, this.relativeX + 10, this.relativeY + 87, 120, value -> {
            MekanismConfig.client.hudJitter.set(99.0 * value + 1.0);
            MekanismConfig.client.save();
        }));
        jitterSlider.setValue((MekanismConfig.client.hudJitter.get() - 1.0f) / 99.0f);
        this.addChild(new GuiScreenSwitch(gui, this.relativeX + 7, this.relativeY + 112, 126, (Component)MekanismLang.COMPASS.translate(), MekanismConfig.client.hudCompassEnabled, (element, mouseX, mouseY) -> {
            MekanismConfig.client.hudCompassEnabled.set(!MekanismConfig.client.hudCompassEnabled.get());
            MekanismConfig.client.save();
            return true;
        }));
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        this.drawTitleText(guiGraphics, (Component)MekanismLang.HELMET_OPTIONS.translate(), 6.0f);
        this.drawTextExact(guiGraphics, (Component)MekanismLang.HUD_OVERLAY.translate(), this.relativeX + 7, this.relativeY + 20, this.headingTextColor());
        this.drawScaledCenteredText(guiGraphics, (Component)MekanismLang.DEFAULT.translate(), this.relativeX + 21, this.relativeY + 52, this.subheadingTextColor(), 0.8f);
        this.drawScaledCenteredText(guiGraphics, (Component)MekanismLang.WARNING.translate(), this.relativeX + 70, this.relativeY + 52, this.subheadingTextColor(), 0.8f);
        this.drawScaledCenteredText(guiGraphics, (Component)MekanismLang.DANGER.translate(), this.relativeX + 119, this.relativeY + 52, this.subheadingTextColor(), 0.8f);
        this.drawScaledCenteredText(guiGraphics, (Component)MekanismLang.OPACITY.translate(Math.round(MekanismConfig.client.hudOpacity.get() * 100.0f)), this.relativeX + 70, this.relativeY + 75, this.subheadingTextColor(), 0.8f);
        this.drawScaledCenteredText(guiGraphics, (Component)MekanismLang.JITTER.translate((int)MekanismConfig.client.hudJitter.get()), this.relativeX + 70, this.relativeY + 100, this.subheadingTextColor(), 0.8f);
    }
}

