/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.item;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiArrowSelection;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.scroll.GuiScrollBar;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.item.SeismicReaderContainer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.IFluidBlock;
import org.jetbrains.annotations.NotNull;

public class GuiSeismicReader
extends GuiMekanism<SeismicReaderContainer> {
    private final List<BlockInfo<?>> blockList = new ArrayList();
    private final Reference2IntMap<Block> frequencies = new Reference2IntOpenHashMap();
    private final int minHeight;
    private MekanismButton upButton;
    private MekanismButton downButton;
    private GuiScrollBar scrollBar;

    public GuiSeismicReader(SeismicReaderContainer container, Inventory inv, Component title) {
        super(container, inv, title);
        this.imageWidth = 147;
        this.imageHeight = 182;
        Player player = inv.player;
        Level level = player.level();
        this.minHeight = level.getMinBuildHeight();
        BlockPos pos = player.blockPosition();
        for (BlockPos p : BlockPos.betweenClosed((BlockPos)new BlockPos(pos.getX(), this.minHeight, pos.getZ()), (BlockPos)pos)) {
            BlockState state = level.getBlockState(p);
            ItemStack stack = state.getCloneItemStack((HitResult)new BlockHitResult(p.getCenter().relative(Direction.UP, 0.5), Direction.UP, p, false), (LevelReader)level, p, player);
            if (stack.isEmpty()) {
                Fluid fluid = Fluids.EMPTY;
                Block block = state.getBlock();
                if (block instanceof LiquidBlock) {
                    LiquidBlock liquidBlock = (LiquidBlock)block;
                    fluid = liquidBlock.getFluid();
                } else {
                    block = state.getBlock();
                    if (block instanceof IFluidBlock) {
                        IFluidBlock fluidBlock = (IFluidBlock)block;
                        fluid = fluidBlock.getFluid();
                    } else {
                        block = state.getBlock();
                        if (block instanceof BubbleColumnBlock) {
                            BubbleColumnBlock bubbleColumn = (BubbleColumnBlock)block;
                            fluid = bubbleColumn.getFluidState(state).getType();
                        }
                    }
                }
                if (fluid == Fluids.EMPTY) {
                    this.blockList.add(new BlockInfo<BlockState>(state, state, null));
                    continue;
                }
                this.blockList.add(new BlockInfo<Fluid>(state, fluid, (graphics, f, x, y) -> {
                    IClientFluidTypeExtensions properties = IClientFluidTypeExtensions.of((Fluid)f);
                    MekanismRenderer.color(graphics, properties.getTintColor());
                    TextureAtlasSprite texture = MekanismRenderer.getSprite(properties.getStillTexture());
                    graphics.blit(x, y, 0, 16, 16, texture);
                    MekanismRenderer.resetColor(graphics);
                }));
                continue;
            }
            this.blockList.add(new BlockInfo<ItemStack>(state, stack, this::renderItem));
        }
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiInnerScreen(this, 7, 11, 63, 49));
        this.addRenderableWidget(new GuiInnerScreen(this, 74, 11, 51, 159));
        this.scrollBar = this.addRenderableWidget(new GuiScrollBar((IGuiWrapper)this, 126, 25, 131, this.blockList::size, () -> 1));
        this.addRenderableWidget(new GuiArrowSelection(this, 76, 81, () -> {
            int currentLayer = this.scrollBar.getCurrentSelection();
            if (currentLayer >= 0) {
                return this.blockList.get(this.blockList.size() - 1 - currentLayer).block().getName();
            }
            return null;
        }));
        this.upButton = this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 126, 11, 14, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "up.png"), (element, mouseX, mouseY) -> this.scrollBar.adjustScroll(1.0)));
        this.downButton = this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 126, 156, 14, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "down.png"), (element, mouseX, mouseY) -> this.scrollBar.adjustScroll(-1.0)));
        this.updateEnabledButtons();
    }

    @Override
    public void containerTick() {
        super.containerTick();
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        int currentLayer = this.scrollBar.getCurrentSelection();
        this.upButton.active = currentLayer > 0;
        this.downButton.active = currentLayer + 1 < this.blockList.size();
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int currentLayer = this.blockList.size() - this.scrollBar.getCurrentSelection() - 1;
        this.drawTextScaledBound(guiGraphics, (Component)TextComponentUtil.build(this.minHeight + currentLayer), 111.0f, 87.0f, this.screenTextColor(), 13.0f);
        for (int i = 0; i < 9; ++i) {
            int layer = currentLayer + (i - 4);
            if (0 > layer || layer >= this.blockList.size()) continue;
            BlockInfo<?> info = this.blockList.get(layer);
            if (info.renderTarget == null) continue;
            int renderX = 92;
            int renderY = 146 - 16 * i;
            if (i == 4) {
                info.render(guiGraphics, renderX, renderY);
                continue;
            }
            PoseStack pose = guiGraphics.pose();
            pose.pushPose();
            pose.translate((float)renderX, (float)renderY, 0.0f);
            if (i < 4) {
                pose.translate(1.7f, 2.5f, 0.0f);
            } else {
                pose.translate(1.5f, 0.0f, 0.0f);
            }
            pose.scale(0.8f, 0.8f, 0.8f);
            info.render(guiGraphics, 0, 0);
            pose.popPose();
        }
        int frequency = 0;
        if (currentLayer >= 0) {
            Block block = this.blockList.get(currentLayer).block();
            MutableComponent displayName = block.getName();
            this.drawTextScaledBound(guiGraphics, (Component)displayName, 10.0f, 16.0f, this.screenTextColor(), 57.0f);
            if (this.frequencies.containsKey((Object)block)) {
                frequency = this.frequencies.getInt((Object)block);
            } else {
                for (BlockInfo<?> info : this.blockList) {
                    if (!info.state().is(block)) continue;
                    ++frequency;
                }
                this.frequencies.put((Object)block, frequency);
            }
        }
        this.drawTextScaledBound(guiGraphics, (Component)MekanismLang.ABUNDANCY.translate(frequency), 10.0f, 26.0f, this.screenTextColor(), 57.0f);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double xDelta, double yDelta) {
        return super.mouseScrolled(mouseX, mouseY, xDelta, yDelta) || this.scrollBar.adjustScroll(yDelta);
    }

    private record BlockInfo<TYPE>(BlockState state, TYPE type, RenderTarget<TYPE> renderTarget) {
        public Block block() {
            return this.state.getBlock();
        }

        public void render(GuiGraphics guiGraphics, int x, int y) {
            this.renderTarget.render(guiGraphics, this.type, x, y);
        }
    }

    @FunctionalInterface
    private static interface RenderTarget<TYPE> {
        public void render(GuiGraphics var1, TYPE var2, int var3, int var4);
    }
}

