/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.client.gui.GuiConfigurableTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiMergedChemicalTankGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSequencedSlotDisplay;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.machine.TileEntityChemicalCrystallizer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiChemicalCrystallizer
extends GuiConfigurableTile<TileEntityChemicalCrystallizer, MekanismTileContainer<TileEntityChemicalCrystallizer>> {
    private final List<ItemStack> iterStacks = new ArrayList<ItemStack>();
    private final IOreInfo oreInfo = new OreInfo();
    private GuiSequencedSlotDisplay slotDisplay;
    @NotNull
    private Slurry prevSlurry = MekanismAPI.EMPTY_SLURRY;

    public GuiChemicalCrystallizer(MekanismTileContainer<TileEntityChemicalCrystallizer> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.dynamicSlots = true;
        this.titleLabelY = 4;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiVerticalPowerBar((IGuiWrapper)this, ((TileEntityChemicalCrystallizer)this.tile).getEnergyContainer(), 157, 23)).warning(WarningTracker.WarningType.NOT_ENOUGH_ENERGY, ((TileEntityChemicalCrystallizer)this.tile).getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY));
        this.addRenderableWidget(new GuiEnergyTab((IGuiWrapper)this, ((TileEntityChemicalCrystallizer)this.tile).getEnergyContainer(), ((TileEntityChemicalCrystallizer)this.tile)::getActive));
        this.addRenderableWidget(new GuiMergedChemicalTankGauge<TileEntityChemicalCrystallizer>(() -> ((TileEntityChemicalCrystallizer)this.tile).inputTank, () -> (TileEntityChemicalCrystallizer)this.tile, GaugeType.STANDARD, this, 7, 4)).warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, ((TileEntityChemicalCrystallizer)this.tile).getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT));
        this.addRenderableWidget((GuiProgress)new GuiProgress(((TileEntityChemicalCrystallizer)this.tile)::getScaledProgress, ProgressType.LARGE_RIGHT, (IGuiWrapper)this, 53, 61).recipeViewerCategory((IRecipeLookupHandler)((Object)this.tile))).warning(WarningTracker.WarningType.INPUT_DOESNT_PRODUCE_OUTPUT, ((TileEntityChemicalCrystallizer)this.tile).getWarningCheck(CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT));
        this.slotDisplay = new GuiSequencedSlotDisplay(this, 129, 14, () -> this.iterStacks);
        this.updateSlotContents();
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)this, 31, 13, 115, 42, () -> GuiChemicalCrystallizer.getScreenRenderStrings(this.oreInfo)));
        this.addRenderableWidget(new GuiSlot(SlotType.ORE, this, 128, 13).setRenderAboveSlots());
        this.addRenderableWidget(this.slotDisplay);
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }

    @Override
    public void containerTick() {
        this.updateSlotContents();
        super.containerTick();
    }

    private void updateSlotContents() {
        BoxedChemicalStack boxedChemical = this.oreInfo.getInputChemical();
        if (!boxedChemical.isEmpty() && boxedChemical.getChemicalType() == ChemicalType.SLURRY) {
            Slurry inputSlurry = (Slurry)boxedChemical.getChemicalStack().getType();
            if (this.prevSlurry != inputSlurry) {
                TagKey<Item> oreTag;
                this.prevSlurry = inputSlurry;
                this.iterStacks.clear();
                if (!this.prevSlurry.isEmptyType() && !this.prevSlurry.is(MekanismTags.Slurries.DIRTY) && (oreTag = this.prevSlurry.getOreTag()) != null) {
                    for (Holder ore : BuiltInRegistries.ITEM.getTagOrEmpty(oreTag)) {
                        this.iterStacks.add(new ItemStack(ore));
                    }
                }
                this.slotDisplay.updateStackList();
            }
        } else if (!this.prevSlurry.isEmptyType()) {
            this.prevSlurry = MekanismAPI.EMPTY_SLURRY;
            this.iterStacks.clear();
            this.slotDisplay.updateStackList();
        }
    }

    public static List<Component> getScreenRenderStrings(IOreInfo oreInfo) {
        BoxedChemicalStack boxedChemical = oreInfo.getInputChemical();
        if (!boxedChemical.isEmpty()) {
            ArrayList<Component> ret = new ArrayList<Component>();
            ret.add(boxedChemical.getTextComponent());
            if (boxedChemical.getChemicalType() == ChemicalType.SLURRY && !oreInfo.getRenderStack().isEmpty()) {
                ret.add((Component)MekanismLang.GENERIC_PARENTHESIS.translate(oreInfo.getRenderStack()));
            } else {
                ChemicalCrystallizerRecipe recipe = oreInfo.getRecipe();
                if (recipe == null) {
                    ret.add((Component)MekanismLang.NO_RECIPE.translate());
                } else {
                    ret.add((Component)MekanismLang.GENERIC_PARENTHESIS.translate(recipe.getOutput(boxedChemical)));
                }
            }
            return ret;
        }
        return Collections.emptyList();
    }

    private class OreInfo
    implements IOreInfo {
        private WeakReference<ChemicalCrystallizerRecipe> cachedRecipe;

        private OreInfo() {
        }

        @Override
        @NotNull
        public BoxedChemicalStack getInputChemical() {
            MergedChemicalTank.Current current = ((TileEntityChemicalCrystallizer)((GuiChemicalCrystallizer)GuiChemicalCrystallizer.this).tile).inputTank.getCurrent();
            return current == MergedChemicalTank.Current.EMPTY ? BoxedChemicalStack.EMPTY : BoxedChemicalStack.box(((TileEntityChemicalCrystallizer)((GuiChemicalCrystallizer)GuiChemicalCrystallizer.this).tile).inputTank.getTankFromCurrent(current).getStack());
        }

        @Override
        @Nullable
        public ChemicalCrystallizerRecipe getRecipe() {
            ChemicalCrystallizerRecipe recipe;
            BoxedChemicalStack input = this.getInputChemical();
            if (input.isEmpty()) {
                return null;
            }
            if (this.cachedRecipe == null) {
                recipe = this.getRecipeAndCache();
            } else {
                recipe = (ChemicalCrystallizerRecipe)this.cachedRecipe.get();
                if (recipe == null || !recipe.testType(input)) {
                    recipe = this.getRecipeAndCache();
                }
            }
            return recipe;
        }

        @Override
        @NotNull
        public ItemStack getRenderStack() {
            return GuiChemicalCrystallizer.this.slotDisplay == null ? ItemStack.EMPTY : GuiChemicalCrystallizer.this.slotDisplay.getRenderStack();
        }

        private ChemicalCrystallizerRecipe getRecipeAndCache() {
            ChemicalCrystallizerRecipe recipe = ((TileEntityChemicalCrystallizer)GuiChemicalCrystallizer.this.tile).getRecipe(0);
            this.cachedRecipe = recipe == null ? null : new WeakReference<ChemicalCrystallizerRecipe>(recipe);
            return recipe;
        }
    }

    public static interface IOreInfo {
        @NotNull
        public BoxedChemicalStack getInputChemical();

        @Nullable
        public ChemicalCrystallizerRecipe getRecipe();

        @NotNull
        public ItemStack getRenderStack();
    }
}

