/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import java.util.Optional;
import mekanism.client.gui.GuiConfigurableTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.ToggleButton;
import mekanism.client.gui.element.button.TooltipToggleButton;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.FormulaAttachment;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.tile.FormulaicAssemblicatorContainer;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.item.ItemCraftingFormula;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.tile.machine.TileEntityFormulaicAssemblicator;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GuiFormulaicAssemblicator
extends GuiConfigurableTile<TileEntityFormulaicAssemblicator, FormulaicAssemblicatorContainer> {
    private MekanismButton encodeFormulaButton;
    private MekanismButton stockControlButton;
    private MekanismButton fillEmptyButton;
    private MekanismButton craftSingleButton;
    private MekanismButton craftAvailableButton;
    private MekanismButton autoModeButton;

    public GuiFormulaicAssemblicator(FormulaicAssemblicatorContainer container, Inventory inv, Component title) {
        super(container, inv, title);
        this.imageHeight += 64;
        this.inventoryLabelY = this.imageHeight - 94;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiVerticalPowerBar((IGuiWrapper)this, ((TileEntityFormulaicAssemblicator)this.tile).getEnergyContainer(), 159, 15)).warning(WarningTracker.WarningType.NOT_ENOUGH_ENERGY, () -> {
            if (((TileEntityFormulaicAssemblicator)this.tile).getAutoMode() && ((TileEntityFormulaicAssemblicator)this.tile).hasRecipe()) {
                MachineEnergyContainer<TileEntityFormulaicAssemblicator> energyContainer = ((TileEntityFormulaicAssemblicator)this.tile).getEnergyContainer();
                return energyContainer.getEnergyPerTick().greaterThan(energyContainer.getEnergy());
            }
            return false;
        });
        this.addRenderableWidget(new GuiSlot(SlotType.OUTPUT_LARGE, this, 115, 16));
        this.addRenderableWidget((GuiProgress)new GuiProgress(() -> (double)((TileEntityFormulaicAssemblicator)this.tile).getOperatingTicks() / (double)((TileEntityFormulaicAssemblicator)this.tile).getTicksRequired(), ProgressType.TALL_RIGHT, (IGuiWrapper)this, 86, 43).recipeViewerCrafting());
        this.addRenderableWidget(new GuiEnergyTab((IGuiWrapper)this, ((TileEntityFormulaicAssemblicator)this.tile).getEnergyContainer(), ((TileEntityFormulaicAssemblicator)this.tile)::usedEnergy));
        this.encodeFormulaButton = this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 7, 45, 14, this.getButtonLocation("encode_formula"), (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.ENCODE_FORMULA, ((GuiFormulaicAssemblicator)element.gui()).tile)))).setTooltip(MekanismLang.ENCODE_FORMULA);
        this.stockControlButton = this.addRenderableWidget(new TooltipToggleButton((IGuiWrapper)this, 26, 75, 16, this.getButtonLocation("stock_control"), ((TileEntityFormulaicAssemblicator)this.tile)::getStockControl, (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.STOCK_CONTROL_BUTTON, ((GuiFormulaicAssemblicator)element.gui()).tile)), (Component)MekanismLang.STOCK_CONTROL.translate(BooleanStateDisplay.OnOff.ON), (Component)MekanismLang.STOCK_CONTROL.translate(BooleanStateDisplay.OnOff.OFF)));
        this.fillEmptyButton = this.addRenderableWidget(new ToggleButton(this, 44, 75, 16, 16, this.getButtonLocation("empty"), this.getButtonLocation("fill"), () -> ((TileEntityFormulaicAssemblicator)this.tile).formula == null, (element, mouseX, mouseY) -> {
            TileEntityFormulaicAssemblicator tile = (TileEntityFormulaicAssemblicator)((GuiFormulaicAssemblicator)element.gui()).tile;
            PacketGuiInteract.GuiInteraction interaction = tile.formula == null ? PacketGuiInteract.GuiInteraction.EMPTY_GRID : PacketGuiInteract.GuiInteraction.FILL_GRID;
            return PacketUtils.sendToServer(new PacketGuiInteract(interaction, tile));
        }, (Component)MekanismLang.EMPTY_ASSEMBLICATOR.translate(), (Component)MekanismLang.FILL_ASSEMBLICATOR.translate()));
        this.craftSingleButton = this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 71, 75, 16, this.getButtonLocation("craft_single"), (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CRAFT_SINGLE, ((GuiFormulaicAssemblicator)element.gui()).tile)))).setTooltip(MekanismLang.CRAFT_SINGLE);
        this.craftAvailableButton = this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 89, 75, 16, this.getButtonLocation("craft_available"), (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CRAFT_ALL, ((GuiFormulaicAssemblicator)element.gui()).tile)))).setTooltip(MekanismLang.CRAFT_AVAILABLE);
        this.autoModeButton = this.addRenderableWidget(new TooltipToggleButton((IGuiWrapper)this, 107, 75, 16, this.getButtonLocation("auto_toggle"), ((TileEntityFormulaicAssemblicator)this.tile)::getAutoMode, (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.NEXT_MODE, ((GuiFormulaicAssemblicator)element.gui()).tile)), (Component)MekanismLang.AUTO_MODE.translate(BooleanStateDisplay.OnOff.ON), (Component)MekanismLang.AUTO_MODE.translate(BooleanStateDisplay.OnOff.OFF)));
        this.updateEnabledButtons();
    }

    @Override
    public void containerTick() {
        super.containerTick();
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        this.encodeFormulaButton.active = !((TileEntityFormulaicAssemblicator)this.tile).getAutoMode() && ((TileEntityFormulaicAssemblicator)this.tile).hasRecipe() && this.canEncode();
        this.stockControlButton.active = ((TileEntityFormulaicAssemblicator)this.tile).hasValidFormula();
        this.fillEmptyButton.active = !((TileEntityFormulaicAssemblicator)this.tile).getAutoMode();
        this.craftSingleButton.active = !((TileEntityFormulaicAssemblicator)this.tile).getAutoMode() && ((TileEntityFormulaicAssemblicator)this.tile).hasRecipe();
        this.craftAvailableButton.active = !((TileEntityFormulaicAssemblicator)this.tile).getAutoMode() && ((TileEntityFormulaicAssemblicator)this.tile).hasRecipe();
        this.autoModeButton.active = ((TileEntityFormulaicAssemblicator)this.tile).hasValidFormula();
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.drawString(guiGraphics, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, this.titleTextColor());
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected ItemStack checkValidity(int slotIndex) {
        Slot slot;
        ItemStack stack;
        int i = slotIndex - 21;
        if (i >= 0 && ((TileEntityFormulaicAssemblicator)this.tile).hasValidFormula() && !(stack = (ItemStack)((TileEntityFormulaicAssemblicator)this.tile).formula.input.get(i)).isEmpty() && ((slot = (Slot)((FormulaicAssemblicatorContainer)this.menu).slots.get(slotIndex)).getItem().isEmpty() || !((TileEntityFormulaicAssemblicator)this.tile).formula.isIngredientInPos(((TileEntityFormulaicAssemblicator)this.tile).getLevel(), slot.getItem(), i))) {
            return stack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        SlotOverlay overlay = ((TileEntityFormulaicAssemblicator)this.tile).hasRecipe() ? SlotOverlay.CHECK : SlotOverlay.X;
        guiGraphics.blit(overlay.getTexture(), this.leftPos + 88, this.topPos + 22, 0.0f, 0.0f, overlay.getWidth(), overlay.getHeight(), overlay.getWidth(), overlay.getHeight());
    }

    private boolean canEncode() {
        ItemStack stack;
        if (!((TileEntityFormulaicAssemblicator)this.tile).hasValidFormula() && !(stack = ((TileEntityFormulaicAssemblicator)this.tile).getFormulaSlot().getStack()).isEmpty() && stack.getItem() instanceof ItemCraftingFormula) {
            Optional existingFormula = stack.getExistingData(MekanismAttachmentTypes.FORMULA_HOLDER);
            if (existingFormula.isEmpty()) {
                return true;
            }
            return existingFormula.filter(FormulaAttachment::isEmpty).isPresent();
        }
        return false;
    }
}

