/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.qio;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.IntSupplier;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiDigitalIconToggle;
import mekanism.client.gui.element.GuiDropdown;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.custom.GuiResizeControls;
import mekanism.client.gui.element.scroll.GuiSlotScroll;
import mekanism.client.gui.element.tab.GuiTargetDirectionTab;
import mekanism.client.gui.element.tab.GuiToggleClientConfigTab;
import mekanism.client.gui.element.tab.window.GuiCraftingWindowTab;
import mekanism.client.gui.element.text.BackgroundType;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.window.GuiCraftingWindow;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.qio.SearchQueryParser;
import mekanism.common.inventory.ISlotClickHandler;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.util.text.TextUtils;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public abstract class GuiQIOItemViewer<CONTAINER extends QIOItemViewerContainer>
extends GuiMekanism<CONTAINER>
implements GuiResizeControls.ResizeController {
    private static final Set<Character> ALLOWED_SPECIAL_CHARS = (Set)Util.make((Object)Sets.newHashSet((Object[])new Character[]{Character.valueOf('_'), Character.valueOf(' '), Character.valueOf('-'), Character.valueOf('/'), Character.valueOf('.'), Character.valueOf('\"'), Character.valueOf('\''), Character.valueOf('|'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf(':')}), allowsChars -> allowsChars.addAll(SearchQueryParser.QueryType.getPrefixChars()));
    protected final Inventory inv;
    private GuiTextField searchField;
    private GuiCraftingWindowTab craftingWindowTab;
    private boolean loadPinned = true;

    protected GuiQIOItemViewer(CONTAINER container, Inventory inv, Component title) {
        super(container, inv, title);
        this.inv = inv;
        this.imageWidth = 16 + MekanismConfig.client.qioItemViewerSlotsX.get() * 18 + 18;
        this.imageHeight = 43 + MekanismConfig.client.qioItemViewerSlotsY.get() * 18 + 96;
        this.inventoryLabelY = this.imageHeight - 94;
        this.titleLabelY = 5;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        int slotsY = MekanismConfig.client.qioItemViewerSlotsY.get();
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)this, 7, 15, this.imageWidth - 16, 12, () -> {
            Frequency.FrequencyIdentity freq = this.getFrequency();
            if (freq == null) {
                return List.of(MekanismLang.NO_FREQUENCY.translate());
            }
            return List.of(MekanismLang.FREQUENCY.translate(freq.key()));
        }).tooltip(() -> {
            if (this.getFrequency() == null) {
                return Collections.emptyList();
            }
            return List.of(MekanismLang.QIO_ITEMS_DETAIL.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextUtils.format(((QIOItemViewerContainer)this.menu).getTotalItems()), TextUtils.format(((QIOItemViewerContainer)this.menu).getCountCapacity())), MekanismLang.QIO_TYPES_DETAIL.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextUtils.format(((QIOItemViewerContainer)this.menu).getTotalTypes()), TextUtils.format(((QIOItemViewerContainer)this.menu).getTypeCapacity())));
        }));
        this.searchField = this.addRenderableWidget(new GuiTextField(this, 50, 30, this.imageWidth - 50 - 10, 10));
        this.searchField.setOffset(0, -1).setInputValidator(this::isValidSearchChar).setBackground(BackgroundType.ELEMENT_HOLDER).setResponder(((QIOItemViewerContainer)this.menu)::updateSearch);
        this.searchField.setMaxLength(50);
        this.searchField.setVisible(true);
        this.searchField.setTextColor(0xFFFFFF);
        if (MekanismConfig.client.qioAutoFocusSearchBar.get()) {
            this.setInitialFocus((GuiEventListener)this.searchField);
        }
        this.addRenderableWidget(new GuiSlotScroll(this, 7, 43, MekanismConfig.client.qioItemViewerSlotsX.get(), slotsY, ((QIOItemViewerContainer)this.menu)::getQIOItemList, (ISlotClickHandler)this.menu));
        this.addRenderableWidget(new GuiDropdown<QIOItemViewerContainer.ListSortType>(this, this.imageWidth - 9 - 54, 43 + slotsY * 18 + 1, 41, QIOItemViewerContainer.ListSortType.class, ((QIOItemViewerContainer)this.menu)::getSortType, ((QIOItemViewerContainer)this.menu)::setSortType));
        this.addRenderableWidget(new GuiDigitalIconToggle<QIOItemViewerContainer.SortDirection>(this, this.imageWidth - 9 - 12, 43 + slotsY * 18 + 1, 12, 12, QIOItemViewerContainer.SortDirection.class, ((QIOItemViewerContainer)this.menu)::getSortDirection, ((QIOItemViewerContainer)this.menu)::setSortDirection));
        this.addRenderableWidget(new GuiTargetDirectionTab(this, (QIOItemViewerContainer)this.menu, 60));
        this.addRenderableWidget(new GuiToggleClientConfigTab(this, this.imageHeight - 35, true, this.getButtonLocation("recipe_viewer_inventory"), this.getButtonLocation("recipe_viewer_frequency"), MekanismConfig.client.qioRejectsToInventory, (Component)MekanismLang.QIO_REJECTS_TO_INVENTORY.translate(), (Component)MekanismLang.QIO_REJECTS_TO_FREQUENCY.translate()));
        this.addRenderableWidget(new GuiToggleClientConfigTab(this, 6, false, this.getButtonLocation("searchbar_autofocus_off"), this.getButtonLocation("searchbar_autofocus_on"), MekanismConfig.client.qioAutoFocusSearchBar, (Component)MekanismLang.QIO_SEARCH_MANUAL_FOCUS.translate(), (Component)MekanismLang.QIO_SEARCH_AUTO_FOCUS.translate()));
        this.addRenderableWidget(new GuiResizeControls(this, this.getMinecraft().getWindow().getGuiScaledHeight() / 2 - this.topPos));
        this.craftingWindowTab = this.addRenderableWidget(new GuiCraftingWindowTab(this, () -> this.craftingWindowTab, (QIOItemViewerContainer)this.menu));
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.drawString(guiGraphics, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, this.titleTextColor());
        this.drawTextScaledBound(guiGraphics, (Component)MekanismLang.LIST_SEARCH.translate(), 7.0f, 31.0f, this.titleTextColor(), 41.0f);
        MutableComponent text = MekanismLang.LIST_SORT.translate();
        this.drawString(guiGraphics, (Component)text, this.imageWidth - 66 - this.getStringWidth((Component)text), this.imageHeight - 92, this.titleTextColor());
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void repositionElements() {
        super.repositionElements();
        int maxY = QIOItemViewerContainer.getSlotsYMax();
        if (MekanismConfig.client.qioItemViewerSlotsY.get() > maxY) {
            MekanismConfig.client.qioItemViewerSlotsY.set(maxY);
            MekanismConfig.client.save();
            this.recreateViewer();
        }
    }

    private boolean isValidSearchChar(char c) {
        return ALLOWED_SPECIAL_CHARS.contains(Character.valueOf(c)) || Character.isDigit(c) || Character.isAlphabetic(c);
    }

    public abstract Frequency.FrequencyIdentity getFrequency();

    @Override
    public void resize(GuiResizeControls.ResizeType type, boolean adjustMax) {
        IntSupplier changeX = null;
        IntSupplier changeY = null;
        switch (type) {
            case EXPAND_X: {
                changeX = adjustMax ? () -> 16 : () -> MekanismConfig.client.qioItemViewerSlotsX.get() + 1;
                break;
            }
            case SHRINK_X: {
                changeX = adjustMax ? () -> 8 : () -> MekanismConfig.client.qioItemViewerSlotsX.get() - 1;
                break;
            }
            case EXPAND_Y: {
                changeY = adjustMax ? QIOItemViewerContainer::getSlotsYMax : () -> MekanismConfig.client.qioItemViewerSlotsY.get() + 1;
                break;
            }
            case SHRINK_Y: {
                IntSupplier intSupplier = changeY = adjustMax ? () -> 2 : () -> MekanismConfig.client.qioItemViewerSlotsY.get() - 1;
            }
        }
        if (changeX != null || changeY != null) {
            if (changeX != null) {
                MekanismConfig.client.qioItemViewerSlotsX.set(Mth.clamp((int)changeX.getAsInt(), (int)8, (int)16));
            }
            if (changeY != null) {
                MekanismConfig.client.qioItemViewerSlotsY.set(Mth.clamp((int)changeY.getAsInt(), (int)2, (int)QIOItemViewerContainer.getSlotsYMax()));
            }
            MekanismConfig.client.save();
            this.recreateViewer();
        }
    }

    private void recreateViewer() {
        QIOItemViewerContainer c = ((QIOItemViewerContainer)this.menu).recreate();
        GuiQIOItemViewer<QIOItemViewerContainer> s = this.recreate(c);
        s.loadPinned = false;
        this.getMinecraft().screen = null;
        this.getMinecraft().player.containerMenu = s.getMenu();
        this.getMinecraft().setScreen(s);
        s.searchField.setText(this.searchField.getText());
        c.updateSearch(this.searchField.getText());
        s.transferWindows(this.windows);
    }

    @Override
    protected void initPinnedWindows() {
        if (this.loadPinned) {
            super.initPinnedWindows();
        }
    }

    protected void transferWindows(Collection<GuiWindow> windows) {
        for (GuiWindow window : windows) {
            if (window instanceof GuiCraftingWindow) {
                GuiCraftingWindow craftingWindow = (GuiCraftingWindow)window;
                this.craftingWindowTab.adoptWindows(craftingWindow);
                craftingWindow.updateContainer((QIOItemViewerContainer)this.menu);
            }
            this.addWindow(window);
            window.transferToNewGui(this);
        }
    }

    public abstract GuiQIOItemViewer<CONTAINER> recreate(CONTAINER var1);
}

