/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.robit;

import mekanism.client.gui.element.text.BackgroundType;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.robit.GuiRobit;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.entity.robit.RepairRobitContainer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GuiRobitRepair
extends GuiRobit<RepairRobitContainer>
implements ContainerListener {
    private static final ResourceLocation TEXT_FIELD_SPRITE = new ResourceLocation("container/anvil/text_field");
    private static final ResourceLocation TEXT_FIELD_DISABLED_SPRITE = new ResourceLocation("container/anvil/text_field_disabled");
    private static final ResourceLocation ERROR_SPRITE = new ResourceLocation("container/anvil/error");
    private static final ResourceLocation ANVIL_LOCATION = new ResourceLocation("textures/gui/container/anvil.png");
    private final Player player;
    private GuiTextField itemNameField;

    public GuiRobitRepair(RepairRobitContainer container, Inventory inv, Component title) {
        super(container, inv, title);
        this.player = inv.player;
        ++this.inventoryLabelY;
        this.titleLabelX = 60;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.itemNameField = this.addRenderableWidget(new GuiTextField(this, 60, 21, 103, 12));
        this.itemNameField.setCanLoseFocus(false);
        this.itemNameField.setTextColor(-1);
        this.itemNameField.setTextColorUneditable(-1);
        this.itemNameField.setBackground(BackgroundType.NONE);
        this.itemNameField.setMaxLength(50);
        this.itemNameField.setResponder(this::onNameChanged);
        this.setInitialFocus((GuiEventListener)this.itemNameField);
        this.itemNameField.setEditable(false);
        ((RepairRobitContainer)this.menu).removeSlotListener(this);
        ((RepairRobitContainer)this.menu).addSlotListener(this);
    }

    @Override
    protected void setInitialFocus(@NotNull GuiEventListener listener) {
        this.initialFocusSet = false;
        super.setInitialFocus(listener);
    }

    private void onNameChanged(String newText) {
        if (!newText.isEmpty()) {
            Slot slot = ((RepairRobitContainer)this.menu).getSlot(0);
            if (slot.hasItem() && !slot.getItem().hasCustomHoverName() && newText.equals(slot.getItem().getHoverName().getString())) {
                newText = "";
            }
            ((RepairRobitContainer)this.menu).setItemName(newText);
            this.getMinecraft().player.connection.send((Packet)new ServerboundRenameItemPacket(newText));
        }
    }

    @Override
    public void removed() {
        super.removed();
        ((RepairRobitContainer)this.menu).removeSlotListener(this);
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.drawString(guiGraphics, this.title, this.titleLabelX, this.titleLabelY, this.titleTextColor());
        int maximumCost = ((RepairRobitContainer)this.menu).getCost();
        if (maximumCost > 0) {
            int k = 8453920;
            boolean flag = true;
            MutableComponent component = MekanismLang.REPAIR_COST.translate(maximumCost);
            if (maximumCost >= 40 && !this.getMinecraft().player.isCreative()) {
                component = MekanismLang.REPAIR_EXPENSIVE.translate();
                k = 0xFF6060;
            } else {
                Slot slot = ((RepairRobitContainer)this.menu).getSlot(2);
                if (!slot.hasItem()) {
                    flag = false;
                } else if (!slot.mayPickup(this.player)) {
                    k = 0xFF6060;
                }
            }
            if (flag) {
                int width = this.imageWidth - 8 - this.getStringWidth((Component)component) - 2;
                guiGraphics.fill(width - 2, 67, this.imageWidth - 8, 79, 0x4F000000);
                guiGraphics.drawString(this.getFont(), (Component)component, width, 69, k);
            }
        }
        this.drawString(guiGraphics, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, this.titleTextColor());
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected boolean shouldOpenGui(GuiRobit.RobitGuiType guiType) {
        return guiType != GuiRobit.RobitGuiType.REPAIR;
    }

    @Override
    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(ANVIL_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        guiGraphics.blitSprite(((RepairRobitContainer)this.menu).getSlot(0).hasItem() ? TEXT_FIELD_SPRITE : TEXT_FIELD_DISABLED_SPRITE, this.leftPos + 59, this.topPos + 20, 110, 16);
        if ((((RepairRobitContainer)this.menu).getSlot(0).hasItem() || ((RepairRobitContainer)this.menu).getSlot(1).hasItem()) && !((RepairRobitContainer)this.menu).getSlot(2).hasItem()) {
            guiGraphics.blitSprite(ERROR_SPRITE, this.leftPos + 99, this.topPos + 45, 28, 21);
        }
    }

    public void slotChanged(@NotNull AbstractContainerMenu container, int slotID, @NotNull ItemStack stack) {
        if (slotID == 0) {
            this.itemNameField.setText(stack.isEmpty() ? "" : stack.getHoverName().getString());
            this.itemNameField.setEditable(!stack.isEmpty());
            this.setFocused((GuiEventListener)this.itemNameField);
        }
    }

    public void dataChanged(@NotNull AbstractContainerMenu container, int slotID, int value) {
    }
}

