/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.tooltip;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.tooltip.MultiLineTooltip;
import mekanism.common.MekanismLang;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class TooltipUtils {
    public static final Tooltip BACK = TooltipUtils.create((ILangEntry)MekanismLang.BACK);

    private TooltipUtils() {
    }

    public static Tooltip create(ILangEntry langEntry) {
        return TooltipUtils.create((Component)langEntry.translate());
    }

    @Contract(value="null -> null")
    public static Tooltip create(@Nullable Component message) {
        if (message == null) {
            return null;
        }
        Tooltip tooltip = Tooltip.create((Component)message);
        tooltip.setDelay(-1);
        return tooltip;
    }

    public static Tooltip create(ILangEntry ... langEntries) {
        if (langEntries == null || langEntries.length == 0) {
            throw new IllegalArgumentException("Messages cannot be null or empty");
        }
        if (langEntries.length == 1) {
            return TooltipUtils.create(langEntries[0]);
        }
        ArrayList<MutableComponent> messages = new ArrayList<MutableComponent>(langEntries.length);
        for (ILangEntry langEntry : langEntries) {
            messages.add(langEntry.translate());
        }
        return new MultiLineTooltip(List.copyOf(messages));
    }

    public static Tooltip create(Component ... messages) {
        if (messages == null || messages.length == 0) {
            throw new IllegalArgumentException("Messages cannot be null or empty");
        }
        if (messages.length == 1) {
            return TooltipUtils.create(messages[0]);
        }
        return new MultiLineTooltip(List.of(messages));
    }

    @Nullable
    public static Tooltip create(List<Component> messages) {
        if (messages.isEmpty()) {
            return null;
        }
        if (messages.size() == 1) {
            return TooltipUtils.create(messages.get(0));
        }
        return new MultiLineTooltip(List.copyOf(messages));
    }
}

