/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import mekanism.common.Mekanism;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.obj.ObjLoader;
import net.neoforged.neoforge.client.model.obj.ObjModel;
import org.jetbrains.annotations.Nullable;

public class BaseModelCache {
    private final Map<ResourceLocation, MekanismModelData> modelMap = new Object2ObjectOpenHashMap();
    private final String modid;

    protected BaseModelCache(String modid) {
        this.modid = modid;
    }

    private ResourceLocation rl(String path) {
        return new ResourceLocation(this.modid, path);
    }

    public void onBake(ModelEvent.BakingCompleted evt) {
        for (MekanismModelData m : this.modelMap.values()) {
            m.reload(evt);
        }
    }

    public void setup(ModelEvent.RegisterAdditional event) {
        for (MekanismModelData mekanismModelData : this.modelMap.values()) {
            mekanismModelData.setup(event);
        }
    }

    protected OBJModelData registerOBJ(String path) {
        return this.registerOBJ(this.rl(path));
    }

    protected OBJModelData registerOBJ(ResourceLocation rl) {
        return this.register(rl, OBJModelData::new);
    }

    protected JSONModelData registerJSON(String path) {
        return this.registerJSON(this.rl(path));
    }

    protected JSONModelData registerJSON(ResourceLocation rl) {
        return this.register(rl, JSONModelData::new);
    }

    protected JSONModelData registerJSONAndBake(ResourceLocation rl) {
        ModelManager modelManager = Minecraft.getInstance().getModelManager();
        ModelBakery modelBakery = modelManager.getModelBakery();
        ModelBakery.ModelBakerImpl baker = new ModelBakery.ModelBakerImpl(modelBakery, (modelLoc, material) -> material.sprite(), rl);
        JSONModelData data = this.registerJSON(rl);
        data.bakedModel = baker.bake(rl, (ModelState)BlockModelRotation.X0_Y0, Material::sprite);
        UnbakedModel unbakedModel = modelBakery.getModel(rl);
        if (unbakedModel instanceof BlockModel) {
            BlockModel blockModel = (BlockModel)unbakedModel;
            data.model = blockModel.customData.getCustomGeometry();
        }
        return data;
    }

    protected <DATA extends MekanismModelData> DATA register(ResourceLocation rl, Function<ResourceLocation, DATA> creator) {
        MekanismModelData data = (MekanismModelData)creator.apply(rl);
        this.modelMap.put(rl, data);
        return (DATA)data;
    }

    public static BakedModel getBakedModel(ModelEvent.BakingCompleted evt, ResourceLocation rl) {
        BakedModel bakedModel = (BakedModel)evt.getModels().get(rl);
        if (bakedModel == null) {
            Mekanism.logger.error("Baked model doesn't exist: {}", (Object)rl.toString());
            return evt.getModelManager().getMissingModel();
        }
        return bakedModel;
    }

    public static class MekanismModelData {
        protected IUnbakedGeometry<?> model;
        protected final ResourceLocation rl;
        private final Map<IGeometryBakingContext, BakedModel> bakedMap = new Object2ObjectOpenHashMap();

        protected MekanismModelData(ResourceLocation rl) {
            this.rl = rl;
        }

        protected void reload(ModelEvent.BakingCompleted evt) {
            this.bakedMap.clear();
        }

        protected void setup(ModelEvent.RegisterAdditional event) {
        }

        public BakedModel bake(IGeometryBakingContext config) {
            BakedModel bakedModel = this.bakedMap.get(config);
            if (bakedModel == null) {
                ModelBakery.ModelBakerImpl baker = new ModelBakery.ModelBakerImpl(Minecraft.getInstance().getModelManager().getModelBakery(), (modelLoc, material) -> material.sprite(), this.rl);
                bakedModel = this.model.bake(config, (ModelBaker)baker, Material::sprite, (ModelState)BlockModelRotation.X0_Y0, ItemOverrides.EMPTY, this.rl);
                this.bakedMap.put(config, bakedModel);
            }
            return bakedModel;
        }

        public IUnbakedGeometry<?> getModel() {
            return this.model;
        }
    }

    public static class OBJModelData
    extends MekanismModelData {
        protected OBJModelData(ResourceLocation rl) {
            super(rl);
        }

        @Override
        protected void reload(ModelEvent.BakingCompleted evt) {
            super.reload(evt);
            this.model = ObjLoader.INSTANCE.loadModel(new ObjModel.ModelSettings(this.rl, true, this.useDiffuseLighting(), true, true, null));
        }

        public ObjModel getModel() {
            return (ObjModel)super.getModel();
        }

        protected boolean useDiffuseLighting() {
            return true;
        }
    }

    public static class JSONModelData
    extends MekanismModelData {
        private BakedModel bakedModel;

        private JSONModelData(ResourceLocation rl) {
            super(rl);
        }

        @Override
        protected void reload(ModelEvent.BakingCompleted evt) {
            super.reload(evt);
            this.bakedModel = BaseModelCache.getBakedModel(evt, this.rl);
            UnbakedModel unbaked = evt.getModelBakery().getModel(this.rl);
            if (unbaked instanceof BlockModel) {
                BlockModel blockModel = (BlockModel)unbaked;
                this.model = blockModel.customData.getCustomGeometry();
            }
        }

        @Override
        protected void setup(ModelEvent.RegisterAdditional event) {
            event.register(this.rl);
        }

        public List<BakedQuad> getQuads(RandomSource random) {
            return this.getBakedModel().getQuads(null, null, random);
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData data, @Nullable RenderType renderType) {
            return this.getBakedModel().getQuads(state, side, rand, data, renderType);
        }

        public BakedModel getBakedModel() {
            return this.bakedModel;
        }
    }
}

