/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import mekanism.client.model.ModelFreeRunners;
import mekanism.client.model.ModelPartData;
import mekanism.common.Mekanism;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import org.jetbrains.annotations.NotNull;

public class ModelArmoredFreeRunners
extends ModelFreeRunners {
    public static final ModelLayerLocation ARMORED_FREE_RUNNER_LAYER = new ModelLayerLocation(Mekanism.rl("armored_free_runners"), "main");
    private static final ModelPartData PLATE_L = new ModelPartData("PlateL", CubeListBuilder.create().mirror().texOffs(0, 11).addBox(0.5f, 21.0f, -3.0f, 3.0f, 2.0f, 1.0f).texOffs(0, 7).addBox(0.5f, 17.0f, -3.0f, 3.0f, 1.0f, 1.0f), new ModelPartData[0]);
    private static final ModelPartData PLATE_R = new ModelPartData("PlateR", CubeListBuilder.create().texOffs(0, 11).addBox(-3.5f, 21.0f, -3.0f, 3.0f, 2.0f, 1.0f).texOffs(0, 7).addBox(-3.5f, 17.0f, -3.0f, 3.0f, 1.0f, 1.0f), new ModelPartData[0]);
    private static final ModelPartData TOP_PLATE_L = new ModelPartData("TopPlateL", CubeListBuilder.create().mirror().texOffs(12, 7).addBox(0.0f, 0.0f, -0.25f, 2.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)1.0f, (float)16.0f, (float)-2.0f, (float)-0.7854f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    private static final ModelPartData TOP_PLATE_R = new ModelPartData("TopPlateR", CubeListBuilder.create().texOffs(12, 7).addBox(-2.0f, 0.0f, -0.25f, 2.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)-1.0f, (float)16.0f, (float)-2.0f, (float)-0.7854f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    private static final ModelPartData CONNECTION_L = new ModelPartData("ConnectionL", CubeListBuilder.create().mirror().texOffs(8, 7).addBox(2.5f, 18.0f, -3.0f, 1.0f, 3.0f, 1.0f).texOffs(8, 7).addBox(0.5f, 18.0f, -3.0f, 1.0f, 3.0f, 1.0f), new ModelPartData[0]);
    private static final ModelPartData CONNECTION_R = new ModelPartData("ConnectionR", CubeListBuilder.create().texOffs(8, 7).addBox(-1.5f, 18.0f, -3.0f, 1.0f, 3.0f, 1.0f).texOffs(8, 7).addBox(-3.5f, 18.0f, -3.0f, 1.0f, 3.0f, 1.0f), new ModelPartData[0]);
    private static final ModelPartData ARMORED_BRACE_L = new ModelPartData("ArmoredBraceL", CubeListBuilder.create().texOffs(10, 12).addBox(0.2f, 17.0f, -2.3f, 4.0f, 1.0f, 1.0f).texOffs(8, 10).addBox(0.2f, 21.0f, -2.3f, 4.0f, 1.0f, 3.0f), new ModelPartData[0]);
    private static final ModelPartData ARMORED_BRACE_R = new ModelPartData("ArmoredBraceR", CubeListBuilder.create().mirror().texOffs(10, 12).addBox(-4.2f, 17.0f, -2.3f, 4.0f, 1.0f, 1.0f).texOffs(8, 10).addBox(-4.2f, 21.0f, -2.3f, 4.0f, 1.0f, 3.0f), new ModelPartData[0]);
    private static final ModelPartData BATTERY_L = new ModelPartData("BatteryL", CubeListBuilder.create().texOffs(22, 11).addBox(1.5f, 18.0f, -3.0f, 1.0f, 2.0f, 1.0f), new ModelPartData[0]);
    private static final ModelPartData BATTERY_R = new ModelPartData("BatteryR", CubeListBuilder.create().texOffs(22, 11).addBox(-2.5f, 18.0f, -3.0f, 1.0f, 2.0f, 1.0f), new ModelPartData[0]);
    private final List<ModelPart> litLeftParts;
    private final List<ModelPart> litRightParts;

    public static LayerDefinition createLayerDefinition() {
        return ModelArmoredFreeRunners.createLayerDefinition(64, 32, SPRING_L, SPRING_R, BRACE_L, BRACE_R, SUPPORT_L, SUPPORT_R, PLATE_L, PLATE_R, TOP_PLATE_L, TOP_PLATE_R, CONNECTION_L, CONNECTION_R, ARMORED_BRACE_L, ARMORED_BRACE_R, BATTERY_L, BATTERY_R);
    }

    public ModelArmoredFreeRunners(EntityModelSet entityModelSet) {
        this(entityModelSet.bakeLayer(ARMORED_FREE_RUNNER_LAYER));
    }

    private ModelArmoredFreeRunners(ModelPart root) {
        super(root);
        this.leftParts.addAll(ModelArmoredFreeRunners.getRenderableParts(root, PLATE_L, TOP_PLATE_L, CONNECTION_L, ARMORED_BRACE_L));
        this.rightParts.addAll(ModelArmoredFreeRunners.getRenderableParts(root, PLATE_R, TOP_PLATE_R, CONNECTION_R, ARMORED_BRACE_R));
        this.litLeftParts = ModelArmoredFreeRunners.getRenderableParts(root, BATTERY_L);
        this.litRightParts = ModelArmoredFreeRunners.getRenderableParts(root, BATTERY_R);
    }

    @Override
    protected void renderLeg(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int light, int overlayLight, float red, float green, float blue, float alpha, boolean left) {
        super.renderLeg(poseStack, vertexConsumer, light, overlayLight, red, green, blue, alpha, left);
        if (left) {
            ModelArmoredFreeRunners.renderPartsToBuffer(this.litLeftParts, poseStack, vertexConsumer, 0xF000F0, overlayLight, red, green, blue, alpha);
        } else {
            ModelArmoredFreeRunners.renderPartsToBuffer(this.litRightParts, poseStack, vertexConsumer, 0xF000F0, overlayLight, red, green, blue, alpha);
        }
    }
}

