/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import mekanism.client.model.MekanismJavaModel;
import mekanism.client.model.ModelPartData;
import mekanism.common.Mekanism;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ModelFreeRunners
extends MekanismJavaModel {
    public static final ModelLayerLocation FREE_RUNNER_LAYER = new ModelLayerLocation(Mekanism.rl("free_runners"), "main");
    private static final ResourceLocation FREE_RUNNER_TEXTURE = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "free_runners.png");
    protected static final ModelPartData SPRING_L = new ModelPartData("SpringL", CubeListBuilder.create().texOffs(8, 0).addBox(1.5f, 18.0f, 0.0f, 1.0f, 6.0f, 1.0f), PartPose.rotation((float)0.1047198f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    protected static final ModelPartData SPRING_R = new ModelPartData("SpringR", CubeListBuilder.create().texOffs(8, 0).addBox(-2.5f, 18.0f, 0.0f, 1.0f, 6.0f, 1.0f), PartPose.rotation((float)0.1047198f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    protected static final ModelPartData BRACE_L = new ModelPartData("BraceL", CubeListBuilder.create().texOffs(12, 0).addBox(0.2f, 18.0f, -0.8f, 4.0f, 2.0f, 3.0f), new ModelPartData[0]);
    protected static final ModelPartData BRACE_R = new ModelPartData("BraceR", CubeListBuilder.create().texOffs(12, 0).addBox(-4.2f, 18.0f, -0.8f, 4.0f, 2.0f, 3.0f), new ModelPartData[0]);
    protected static final ModelPartData SUPPORT_L = new ModelPartData("SupportL", CubeListBuilder.create().addBox(1.0f, 16.5f, -4.2f, 2.0f, 4.0f, 2.0f), PartPose.rotation((float)0.296706f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    protected static final ModelPartData SUPPORT_R = new ModelPartData("SupportR", CubeListBuilder.create().addBox(-3.0f, 16.5f, -4.2f, 2.0f, 4.0f, 2.0f), PartPose.rotation((float)0.296706f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    private final RenderType RENDER_TYPE = this.renderType(FREE_RUNNER_TEXTURE);
    protected final List<ModelPart> leftParts;
    protected final List<ModelPart> rightParts;

    public static LayerDefinition createLayerDefinition() {
        return ModelFreeRunners.createLayerDefinition(64, 32, SPRING_L, SPRING_R, BRACE_L, BRACE_R, SUPPORT_L, SUPPORT_R);
    }

    public ModelFreeRunners(EntityModelSet entityModelSet) {
        this(entityModelSet.bakeLayer(FREE_RUNNER_LAYER));
    }

    protected ModelFreeRunners(ModelPart root) {
        super(RenderType::entitySolid);
        this.leftParts = ModelFreeRunners.getRenderableParts(root, SPRING_L, BRACE_L, SUPPORT_L);
        this.rightParts = ModelFreeRunners.getRenderableParts(root, SPRING_R, BRACE_R, SUPPORT_R);
    }

    public void render(@NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight, boolean hasEffect) {
        this.renderToBuffer(matrix, ModelFreeRunners.getVertexConsumer(renderer, this.RENDER_TYPE, hasEffect), light, overlayLight, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int light, int overlayLight, float red, float green, float blue, float alpha) {
        this.renderLeg(poseStack, vertexConsumer, light, overlayLight, red, green, blue, alpha, true);
        this.renderLeg(poseStack, vertexConsumer, light, overlayLight, red, green, blue, alpha, false);
    }

    public void renderLeg(@NotNull PoseStack poseStack, @NotNull MultiBufferSource renderer, int light, int overlayLight, boolean hasEffect, boolean left) {
        this.renderLeg(poseStack, ModelFreeRunners.getVertexConsumer(renderer, this.RENDER_TYPE, hasEffect), light, overlayLight, 1.0f, 1.0f, 1.0f, 1.0f, left);
    }

    protected void renderLeg(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int light, int overlayLight, float red, float green, float blue, float alpha, boolean left) {
        if (left) {
            ModelFreeRunners.renderPartsToBuffer(this.leftParts, poseStack, vertexConsumer, light, overlayLight, red, green, blue, alpha);
        } else {
            ModelFreeRunners.renderPartsToBuffer(this.rightParts, poseStack, vertexConsumer, light, overlayLight, red, green, blue, alpha);
        }
    }
}

