/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mekanism.api.text.EnumColor;
import mekanism.client.model.MekanismJavaModel;
import mekanism.client.model.ModelPartData;
import mekanism.common.Mekanism;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ModelTransporterBox
extends MekanismJavaModel {
    public static final ModelLayerLocation BOX_LAYER = new ModelLayerLocation(Mekanism.rl("transporter_box"), "main");
    private static final ResourceLocation BOX_TEXTURE = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "transporter_box.png");
    private static final ModelPartData BOX = new ModelPartData("box", CubeListBuilder.create().addBox(0.0f, 0.0f, 0.0f, 7.0f, 7.0f, 7.0f), PartPose.offset((float)-3.5f, (float)0.0f, (float)-3.5f), new ModelPartData[0]);
    private final RenderType RENDER_TYPE = this.renderType(BOX_TEXTURE);
    private final ModelPart box;

    public static LayerDefinition createLayerDefinition() {
        return ModelTransporterBox.createLayerDefinition(64, 64, BOX);
    }

    public ModelTransporterBox(EntityModelSet entityModelSet) {
        super(RenderType::entityCutoutNoCull);
        ModelPart root = entityModelSet.bakeLayer(BOX_LAYER);
        this.box = BOX.getFromRoot(root);
    }

    public void render(@NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight, float x, float y, float z, EnumColor color) {
        matrix.pushPose();
        matrix.translate(x, y, z);
        this.renderToBuffer(matrix, renderer.getBuffer(this.RENDER_TYPE), 0xF000F0, overlayLight, color.getColor(0), color.getColor(1), color.getColor(2), 1.0f);
        matrix.popPose();
    }

    public void renderToBuffer(@NotNull PoseStack matrix, @NotNull VertexConsumer vertexBuilder, int light, int overlayLight, float red, float green, float blue, float alpha) {
        this.box.render(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
    }
}

