/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model.baked;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.model.MekanismModelCache;
import mekanism.client.model.baked.ExtensionBakedModel;
import mekanism.client.model.baked.ExtensionOverrideBakedModel;
import mekanism.client.model.baked.ModelDataBakedModel;
import mekanism.client.render.lib.Quad;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.common.attachments.DriveMetadata;
import mekanism.common.attachments.FrequencyAware;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.content.qio.IQIODriveItem;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IFrequencyItem;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.qio.TileEntityQIODriveArray;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class DriveArrayBakedModel
extends ExtensionOverrideBakedModel<byte[]> {
    private static final BiPredicate<byte[], byte[]> DATA_EQUALITY_CHECK = Arrays::equals;
    private static final float[][] DRIVE_PLACEMENTS = new float[][]{{0.0f, 0.375f}, {-0.125f, 0.375f}, {-0.25f, 0.375f}, {-0.4375f, 0.375f}, {-0.5625f, 0.375f}, {-0.6875f, 0.375f}, {0.0f, 0.0f}, {-0.125f, 0.0f}, {-0.25f, 0.0f}, {-0.4375f, 0.0f}, {-0.5625f, 0.0f}, {-0.6875f, 0.0f}};

    public DriveArrayBakedModel(BakedModel original) {
        super(original, DriveArrayOverrideList::new);
    }

    @Override
    public List<BakedQuad> createQuads(ExtensionBakedModel.QuadsKey<byte[]> key) {
        byte[] driveStatus = Objects.requireNonNull(key.getData());
        BlockState blockState = Objects.requireNonNull(key.getBlockState());
        RenderType renderType = key.getLayer();
        QuadTransformation rotation = QuadTransformation.rotate(Attribute.getFacing(blockState));
        Direction side = key.getSide();
        ArrayList<BakedQuad> driveQuads = new ArrayList<BakedQuad>();
        for (int i = 0; i < driveStatus.length; ++i) {
            TileEntityQIODriveArray.DriveStatus status = TileEntityQIODriveArray.DriveStatus.STATUSES[driveStatus[i]];
            if (status == TileEntityQIODriveArray.DriveStatus.NONE) continue;
            float[] translation = DRIVE_PLACEMENTS[i];
            QuadTransformation transformation = QuadTransformation.translate(translation[0], translation[1], 0.0);
            for (BakedQuad bakedQuad : MekanismModelCache.INSTANCE.QIO_DRIVES[status.ordinal()].getQuads(blockState, side, key.getRandom(), ModelData.EMPTY, renderType)) {
                Quad quad = new Quad(bakedQuad);
                if (quad.transform(transformation, rotation)) {
                    driveQuads.add(quad.bake());
                    continue;
                }
                driveQuads.add(bakedQuad);
            }
        }
        if (!driveQuads.isEmpty()) {
            ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>(key.getQuads());
            ret.addAll(driveQuads);
            return ret;
        }
        return key.getQuads();
    }

    @Override
    @Nullable
    public ExtensionBakedModel.QuadsKey<byte[]> createKey(ExtensionBakedModel.QuadsKey<byte[]> key, ModelData data) {
        byte[] driveStatus;
        if (key.getBlockState() != null && key.getSide() == null && (driveStatus = (byte[])data.get(TileEntityQIODriveArray.DRIVE_STATUS_PROPERTY)) != null) {
            return key.data(driveStatus, Arrays.hashCode(driveStatus), DATA_EQUALITY_CHECK);
        }
        return null;
    }

    protected DriveArrayBakedModel wrapModel(BakedModel model) {
        return new DriveArrayBakedModel(model);
    }

    private static class DriveArrayOverrideList
    extends ExtensionOverrideBakedModel.ExtendedItemOverrides {
        DriveArrayOverrideList(ItemOverrides original) {
            super(original);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public BakedModel resolve(BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            block6: {
                if (stack.isEmpty() || !stack.is((Item)MekanismBlocks.QIO_DRIVE_ARRAY.asItem())) break block6;
                inventorySlots = ContainerType.ITEM.getAttachmentContainersIfPresent((IAttachmentHolder)stack);
                driveStatus = new byte[12];
                hasFrequency = this.hasFrequency(stack);
                allEmpty = true;
                for (i = 0; i < driveStatus.length; ++i) {
                    driveStack = i < inventorySlots.size() ? inventorySlots.get(i).getStack() : ItemStack.EMPTY;
                    if (driveStack.isEmpty() || !((var14_15 = driveStack.getItem()) instanceof IQIODriveItem)) ** GOTO lbl-1000
                    driveItem = (IQIODriveItem)var14_15;
                    if (!driveStack.hasData(MekanismAttachmentTypes.DRIVE_METADATA)) lbl-1000:
                    // 2 sources

                    {
                        status = TileEntityQIODriveArray.DriveStatus.NONE;
                    } else if (hasFrequency) {
                        allEmpty = false;
                        metadata = (DriveMetadata)driveStack.getData(MekanismAttachmentTypes.DRIVE_METADATA);
                        countCapacity = driveItem.getCountCapacity(driveStack);
                        status = metadata.count() == countCapacity ? TileEntityQIODriveArray.DriveStatus.FULL : (metadata.types() == driveItem.getTypeCapacity(driveStack) || (double)metadata.count() >= (double)countCapacity * 0.75 ? TileEntityQIODriveArray.DriveStatus.NEAR_FULL : TileEntityQIODriveArray.DriveStatus.READY);
                    } else {
                        allEmpty = false;
                        status = TileEntityQIODriveArray.DriveStatus.OFFLINE;
                    }
                    driveStatus[i] = status.status();
                }
                if (!allEmpty) {
                    modelData = ModelData.builder().with(TileEntityQIODriveArray.DRIVE_STATUS_PROPERTY, (Object)driveStatus).build();
                    return this.wrap(model, stack, world, entity, seed, modelData, (BiFunction<BakedModel, ModelData, ModelDataBakedModel>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.client.resources.model.BakedModel net.neoforged.neoforge.client.model.data.ModelData ), (Lnet/minecraft/client/resources/model/BakedModel;Lnet/neoforged/neoforge/client/model/data/ModelData;)Lmekanism/client/model/baked/ModelDataBakedModel;)());
                }
            }
            return this.original.resolve(model, stack, world, entity, seed);
        }

        private boolean hasFrequency(ItemStack stack) {
            IFrequencyItem frequencyItem;
            Item item = stack.getItem();
            if (item instanceof IFrequencyItem && (frequencyItem = (IFrequencyItem)item).getFrequencyType() == FrequencyType.QIO) {
                FrequencyAware frequencyAware = (FrequencyAware)stack.getData(MekanismAttachmentTypes.FREQUENCY_AWARE);
                return frequencyAware.getIdentity() != null && frequencyAware.getOwner() != null;
            }
            return false;
        }

        private static class DriveStatusBakedModel
        extends ModelDataBakedModel {
            private final BlockState targetState = MekanismBlocks.QIO_DRIVE_ARRAY.defaultState();

            public DriveStatusBakedModel(BakedModel original, ModelData data) {
                super(original, data);
            }

            @NotNull
            public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData data, @Nullable RenderType renderType) {
                return super.getQuads(state == null ? this.targetState : state, side, rand, data, renderType);
            }
        }
    }
}

