/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.model.data.DataBasedBakedModel;
import mekanism.common.Mekanism;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class DataBasedGeometry
implements IUnbakedGeometry<DataBasedGeometry> {
    private final Map<ModelProperty<Void>, UnbakedModel> propertyBasedUnbakedModels = new HashMap<ModelProperty<Void>, UnbakedModel>();
    private final Map<ModelProperty<Void>, ResourceLocation> propertyBasedModels;
    private final ResourceLocation noData;
    @Nullable
    private UnbakedModel unbakedModel;

    DataBasedGeometry(ResourceLocation noData, Map<ModelProperty<Void>, ResourceLocation> propertyBasedModels) {
        this.noData = noData;
        this.propertyBasedModels = propertyBasedModels;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        BakedModel bakedModel;
        Objects.requireNonNull(this.unbakedModel, "Unbaked model should not be null");
        UnbakedModel unbakedModel = this.unbakedModel;
        if (unbakedModel instanceof BlockModel) {
            BlockModel unbakedBlock = (BlockModel)unbakedModel;
            bakedModel = unbakedBlock.bake(baker, unbakedBlock, spriteGetter, modelState, modelLocation, context.useBlockLight());
        } else {
            bakedModel = this.unbakedModel.bake(baker, spriteGetter, modelState, modelLocation);
        }
        Objects.requireNonNull(bakedModel, "Baked model should not be null");
        HashMap<ModelProperty, BakedModel> propertyBasedBakedModels = new HashMap<ModelProperty, BakedModel>(this.propertyBasedUnbakedModels.size());
        for (Map.Entry entry : this.propertyBasedUnbakedModels.entrySet()) {
            BakedModel baked;
            Object v = entry.getValue();
            if (v instanceof BlockModel) {
                BlockModel unbakedBlock = (BlockModel)v;
                baked = unbakedBlock.bake(baker, unbakedBlock, spriteGetter, modelState, modelLocation, context.useBlockLight());
            } else {
                baked = ((UnbakedModel)entry.getValue()).bake(baker, spriteGetter, modelState, modelLocation);
            }
            Objects.requireNonNull(baked, "Baked model should not be null");
            propertyBasedBakedModels.put((ModelProperty)entry.getKey(), baked);
        }
        return new DataBasedBakedModel(bakedModel, Collections.unmodifiableMap(propertyBasedBakedModels));
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        this.unbakedModel = this.resolve(modelGetter, context, this.noData);
        for (Map.Entry<ModelProperty<Void>, ResourceLocation> entry : this.propertyBasedModels.entrySet()) {
            this.propertyBasedUnbakedModels.put(entry.getKey(), this.resolve(modelGetter, context, entry.getValue()));
        }
    }

    private UnbakedModel resolve(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context, ResourceLocation modelName) {
        UnbakedModel model = modelGetter.apply(modelName);
        if (model == null) {
            Mekanism.logger.warn("Could not find '{}' while loading model '{}'", (Object)modelName, (Object)context.getModelName());
            model = modelGetter.apply((ResourceLocation)ModelBakery.MISSING_MODEL_LOCATION);
        } else {
            model.resolveParents(modelGetter);
        }
        return model;
    }
}

