/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model.robit;

import java.util.List;
import java.util.function.BiPredicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.robit.RobitSkin;
import mekanism.client.RobitSpriteUploader;
import mekanism.client.model.MekanismModelCache;
import mekanism.client.model.baked.ExtensionBakedModel;
import mekanism.client.model.baked.ExtensionOverrideBakedModel;
import mekanism.client.model.robit.RobitModelDataBakedModel;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.client.render.lib.QuadUtils;
import mekanism.common.entity.EntityRobit;
import mekanism.common.item.ItemRobit;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.registries.MekanismRobitSkins;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class RobitBakedModel
extends ExtensionOverrideBakedModel<ResourceLocation> {
    private static final BiPredicate<ResourceLocation, ResourceLocation> DATA_EQUALITY_CHECK = ResourceLocation::equals;

    public RobitBakedModel(BakedModel original) {
        super(original, RobitItemOverrideList::new);
    }

    @Override
    public List<BakedQuad> createQuads(ExtensionBakedModel.QuadsKey<ResourceLocation> key) {
        List<BakedQuad> quads = key.getQuads();
        if (RobitSpriteUploader.UPLOADER != null) {
            ResourceLocation selectedTexture = key.getData();
            QuadTransformation transformation = QuadTransformation.texture(RobitSpriteUploader.UPLOADER.getSprite(selectedTexture));
            transformation = QuadTransformation.TextureFilteredTransformation.of(transformation, rl -> rl.getPath().equals("missingno"));
            quads = QuadUtils.transformBakedQuads(quads, transformation);
        }
        return quads;
    }

    @Override
    @Nullable
    public ExtensionBakedModel.QuadsKey<ResourceLocation> createKey(ExtensionBakedModel.QuadsKey<ResourceLocation> key, ModelData data) {
        ResourceLocation skinTexture = (ResourceLocation)data.get(EntityRobit.SKIN_TEXTURE_PROPERTY);
        if (skinTexture == null) {
            return null;
        }
        return key.data(skinTexture, skinTexture.hashCode(), DATA_EQUALITY_CHECK);
    }

    protected RobitBakedModel wrapModel(BakedModel model) {
        return new RobitBakedModel(model);
    }

    private static class RobitItemOverrideList
    extends ExtensionOverrideBakedModel.ExtendedItemOverrides {
        RobitItemOverrideList(ItemOverrides original) {
            super(original);
        }

        @Override
        @Nullable
        public BakedModel resolve(BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            if (!stack.isEmpty() && stack.getItem() instanceof ItemRobit) {
                BakedModel customModel;
                RegistryAccess registryAccess;
                if (world != null) {
                    registryAccess = world.registryAccess();
                } else if (entity != null) {
                    registryAccess = entity.level().registryAccess();
                } else {
                    ClientLevel level = Minecraft.getInstance().level;
                    if (level == null) {
                        return this.original.resolve(model, stack, null, null, seed);
                    }
                    registryAccess = level.registryAccess();
                }
                ResourceKey skinKey = (ResourceKey)stack.getData(MekanismAttachmentTypes.ROBIT_SKIN);
                MekanismRobitSkins.SkinLookup skinLookup = MekanismRobitSkins.lookup(registryAccess, (ResourceKey<RobitSkin>)skinKey);
                RobitSkin skin = skinLookup.skin();
                if (skin.customModel() != null && (customModel = MekanismModelCache.INSTANCE.getRobitSkin(skinLookup)) != null && customModel != model) {
                    return customModel.getOverrides().resolve(customModel, stack, world, entity, seed);
                }
                List<ResourceLocation> textures = skin.textures();
                if (!textures.isEmpty()) {
                    ModelData modelData = ModelData.builder().with(EntityRobit.SKIN_TEXTURE_PROPERTY, (Object)textures.get(0)).build();
                    return this.wrap(model, stack, world, entity, seed, modelData, RobitModelDataBakedModel::new);
                }
            }
            return this.original.resolve(model, stack, world, entity, seed);
        }
    }
}

