/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.emi;

import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiStackSerializer;
import java.util.Optional;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.client.recipe_viewer.emi.ChemicalEmiStack;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

@NothingNullByDefault
public class ChemicalEmiIngredientSerializer<CHEMICAL extends Chemical<CHEMICAL>, EMI_STACK extends ChemicalEmiStack<CHEMICAL>>
implements EmiStackSerializer<EMI_STACK> {
    private final EmiStackCreator<CHEMICAL, EMI_STACK> stackCreator;
    final Registry<CHEMICAL> registry;
    private final String type;

    public ChemicalEmiIngredientSerializer(String type, Registry<CHEMICAL> registry, EmiStackCreator<CHEMICAL, EMI_STACK> stackCreator) {
        this.type = type;
        this.registry = registry;
        this.stackCreator = stackCreator;
    }

    public EmiStack create(CHEMICAL chemical) {
        return this.stackCreator.create(chemical, 1L);
    }

    public EmiStack create(ResourceLocation id, CompoundTag nbt, long amount) {
        Optional<Chemical> chemical = this.registry.getOptional(id).filter(c -> !c.isEmptyType());
        if (chemical.isPresent()) {
            return this.stackCreator.create(chemical.get(), amount);
        }
        return EmiStack.EMPTY;
    }

    public String getType() {
        return this.type;
    }

    @FunctionalInterface
    public static interface EmiStackCreator<CHEMICAL extends Chemical<CHEMICAL>, EMI_STACK extends ChemicalEmiStack<CHEMICAL>> {
        public EMI_STACK create(CHEMICAL var1, long var2);
    }
}

