/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.emi;

import dev.emi.emi.api.render.EmiRender;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.text.EnumColor;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class ChemicalEmiStack<CHEMICAL extends Chemical<CHEMICAL>>
extends EmiStack {
    private final CHEMICAL chemical;

    protected ChemicalEmiStack(ChemicalStack<CHEMICAL> stack) {
        this(stack.getType(), stack.getAmount());
    }

    protected ChemicalEmiStack(CHEMICAL chemical, long amount) {
        this.chemical = chemical;
        this.amount = amount;
    }

    public boolean isHidden() {
        return ((Chemical)this.chemical).isHidden();
    }

    protected abstract ChemicalEmiStack<CHEMICAL> construct(CHEMICAL var1, long var2);

    public EmiStack copy() {
        ChemicalEmiStack<CHEMICAL> e = this.construct(this.chemical, this.amount);
        e.setChance(this.chance);
        e.setRemainder(this.getRemainder().copy());
        e.comparison = this.comparison;
        return e;
    }

    public void render(GuiGraphics graphics, int x, int y, float delta, int flags) {
        if ((flags & 1) != 0) {
            ResourceLocation texture = ((Chemical)this.chemical).getIcon();
            int color = ((Chemical)this.chemical).getTint();
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(texture);
            float red = MekanismRenderer.getRed(color);
            float green = MekanismRenderer.getGreen(color);
            float blue = MekanismRenderer.getBlue(color);
            graphics.blit(x, y, 0, 16, 16, sprite, red, green, blue, 1.0f);
        }
        if ((flags & 8) != 0) {
            EmiRender.renderRemainderIcon((EmiIngredient)this, (GuiGraphics)graphics, (int)x, (int)y);
        }
    }

    public boolean isEmpty() {
        return ((Chemical)this.chemical).isEmptyType() || this.amount == 0L;
    }

    @Nullable
    public CompoundTag getNbt() {
        return null;
    }

    public CHEMICAL getKey() {
        return this.chemical;
    }

    public ResourceLocation getId() {
        return ((Chemical)this.chemical).getRegistryName();
    }

    public List<Component> getTooltipText() {
        if (((Chemical)this.chemical).isEmptyType()) {
            return Collections.emptyList();
        }
        ArrayList<Component> tooltips = new ArrayList<Component>();
        tooltips.add(this.getName());
        ChemicalUtil.addChemicalDataToTooltip(tooltips, this.chemical, false);
        return tooltips;
    }

    public List<ClientTooltipComponent> getTooltip() {
        List<ClientTooltipComponent> tooltips = this.getTooltipText().stream().map(EmiTooltipComponents::of).collect(Collectors.toList());
        if (this.amount > 1L) {
            tooltips.add(EmiTooltipComponents.of((Component)MekanismLang.GENERIC_MB.translateColored(EnumColor.GRAY, TextUtils.format(this.amount))));
        }
        EmiTooltipComponents.appendModName(tooltips, (String)this.getId().getNamespace());
        tooltips.addAll(super.getTooltip());
        return tooltips;
    }

    public Component getName() {
        return ((Chemical)this.chemical).getTextComponent();
    }

    public static ChemicalEmiStack<?> create(ChemicalStack<?> stack) {
        return ChemicalEmiStack.create(stack.getType(), stack.getAmount());
    }

    public static ChemicalEmiStack<?> create(Chemical<?> chemical, long amount) {
        ChemicalType type = ChemicalType.getTypeFor(chemical);
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalType.GAS -> new GasEmiStack((Gas)chemical, amount);
            case ChemicalType.INFUSION -> new InfusionEmiStack((InfuseType)chemical, amount);
            case ChemicalType.PIGMENT -> new PigmentEmiStack((Pigment)chemical, amount);
            case ChemicalType.SLURRY -> new SlurryEmiStack((Slurry)chemical, amount);
        };
    }

    public static class GasEmiStack
    extends ChemicalEmiStack<Gas> {
        public GasEmiStack(Gas gas, long amount) {
            super(gas, amount);
        }

        protected GasEmiStack construct(Gas gas, long amount) {
            return new GasEmiStack(gas, amount);
        }
    }

    public static class InfusionEmiStack
    extends ChemicalEmiStack<InfuseType> {
        public InfusionEmiStack(InfuseType infuseType, long amount) {
            super(infuseType, amount);
        }

        protected InfusionEmiStack construct(InfuseType infuseType, long amount) {
            return new InfusionEmiStack(infuseType, amount);
        }
    }

    public static class PigmentEmiStack
    extends ChemicalEmiStack<Pigment> {
        public PigmentEmiStack(Pigment pigment, long amount) {
            super(pigment, amount);
        }

        protected PigmentEmiStack construct(Pigment pigment, long amount) {
            return new PigmentEmiStack(pigment, amount);
        }
    }

    public static class SlurryEmiStack
    extends ChemicalEmiStack<Slurry> {
        public SlurryEmiStack(Slurry slurry, long amount) {
            super(slurry, amount);
        }

        protected SlurryEmiStack construct(Slurry slurry, long amount) {
            return new SlurryEmiStack(slurry, amount);
        }
    }
}

