/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.emi;

import dev.emi.emi.api.EmiStackProvider;
import dev.emi.emi.api.neoforge.NeoForgeEmiStack;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import mekanism.api.chemical.ChemicalStack;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.recipe_viewer.GuiElementHandler;
import mekanism.client.recipe_viewer.emi.ChemicalEmiStack;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class EmiStackUnderMouseProvider
implements EmiStackProvider<Screen> {
    public EmiStackInteraction getStackAt(Screen screen, int x, int y) {
        if (screen instanceof GuiMekanism) {
            GuiMekanism gui = (GuiMekanism)screen;
            return GuiElementHandler.getClickableIngredientUnderMouse(gui, x, y, (helper, ingredient) -> {
                ChemicalEmiStack<?> emiStack;
                if (ingredient instanceof ItemStack) {
                    ItemStack stack = (ItemStack)ingredient;
                    emiStack = EmiStack.of((ItemStack)stack);
                } else if (ingredient instanceof FluidStack) {
                    FluidStack stack = (FluidStack)ingredient;
                    emiStack = NeoForgeEmiStack.of((FluidStack)stack);
                } else if (ingredient instanceof ChemicalStack) {
                    ChemicalStack stack = (ChemicalStack)ingredient;
                    emiStack = ChemicalEmiStack.create(stack);
                } else {
                    return null;
                }
                return new EmiStackInteraction(emiStack, null, false);
            }).orElse(EmiStackInteraction.EMPTY);
        }
        return EmiStackInteraction.EMPTY;
    }
}

