/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Collections;
import java.util.List;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.machine.GuiChemicalCrystallizer;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.emi.MekanismEmiRecipeCategory;
import mekanism.client.recipe_viewer.emi.recipe.MekanismEmiHolderRecipe;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.tile.component.config.DataType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class ChemicalCrystallizerEmiRecipe
extends MekanismEmiHolderRecipe<ChemicalCrystallizerRecipe> {
    private final List<ItemStack> displayItems;
    private final GuiChemicalCrystallizer.IOreInfo oreInfo;

    public ChemicalCrystallizerEmiRecipe(MekanismEmiRecipeCategory category, RecipeHolder<ChemicalCrystallizerRecipe> recipeHolder) {
        super(category, recipeHolder);
        List<Object> list;
        this.addItemOutputDefinition(((ChemicalCrystallizerRecipe)this.recipe).getOutputDefinition());
        ChemicalStackIngredient<?, ?> input = ((ChemicalCrystallizerRecipe)this.recipe).getInput();
        this.addInputDefinition(input);
        final List inputRepresentations = input.getRepresentations();
        if (input instanceof ChemicalStackIngredient.SlurryStackIngredient) {
            ChemicalStackIngredient.SlurryStackIngredient ingredient = (ChemicalStackIngredient.SlurryStackIngredient)input;
            list = RecipeViewerUtils.getDisplayItems(ingredient);
        } else {
            list = Collections.emptyList();
        }
        this.displayItems = list;
        this.oreInfo = new GuiChemicalCrystallizer.IOreInfo(){

            @Override
            @NotNull
            public BoxedChemicalStack getInputChemical() {
                return inputRepresentations.isEmpty() ? BoxedChemicalStack.EMPTY : BoxedChemicalStack.box((ChemicalStack)RecipeViewerUtils.getCurrent(inputRepresentations));
            }

            @Override
            public ChemicalCrystallizerRecipe getRecipe() {
                return (ChemicalCrystallizerRecipe)ChemicalCrystallizerEmiRecipe.this.recipe;
            }

            @Override
            @NotNull
            public ItemStack getRenderStack() {
                return ChemicalCrystallizerEmiRecipe.this.displayItems.isEmpty() ? ItemStack.EMPTY : RecipeViewerUtils.getCurrent(ChemicalCrystallizerEmiRecipe.this.displayItems);
            }
        };
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        this.initTank(widgetHolder, GuiGasGauge.getDummy(GaugeType.STANDARD.with(DataType.INPUT), this, 7, 4), this.input(0));
        this.addSlot(widgetHolder, SlotType.INPUT, 8, 65).with(SlotOverlay.PLUS);
        this.addSlot(widgetHolder, SlotType.OUTPUT, 129, 57, this.output(0)).recipeContext((EmiRecipe)this);
        this.addSimpleProgress(widgetHolder, ProgressType.LARGE_RIGHT, 53, 61, 200);
        this.addElement(widgetHolder, new GuiInnerScreen((IGuiWrapper)this, 31, 13, 115, 42, () -> GuiChemicalCrystallizer.getScreenRenderStrings(this.oreInfo)));
        GuiSlot slurryOreSlot = this.addElement(widgetHolder, new GuiSlot(SlotType.ORE, this, 128, 13).setRenderAboveSlots());
        this.initItem(widgetHolder, slurryOreSlot.getX(), slurryOreSlot.getY(), this.ingredient(this.displayItems));
    }
}

