/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IEmptyStackProvider;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IEmptyGasProvider;
import mekanism.api.chemical.infuse.IEmptyInfusionProvider;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IEmptyPigmentProvider;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.IEmptySlurryProvider;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.util.ChemicalUtil;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class ChemicalStackHelper<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
implements IIngredientHelper<STACK>,
IEmptyStackProvider<CHEMICAL, STACK> {
    @Nullable
    private IColorHelper colorHelper;

    void setColorHelper(IColorHelper colorHelper) {
        this.colorHelper = colorHelper;
    }

    protected abstract String getType();

    public String getDisplayName(STACK ingredient) {
        return TextComponentUtil.build(ingredient).getString();
    }

    public String getUniqueId(STACK ingredient, UidContext context) {
        return this.getType().toLowerCase(Locale.ROOT) + ":" + ((ChemicalStack)ingredient).getTypeRegistryName();
    }

    public ResourceLocation getResourceLocation(STACK ingredient) {
        return ((ChemicalStack)ingredient).getTypeRegistryName();
    }

    public ItemStack getCheatItemStack(STACK ingredient) {
        return ChemicalUtil.getFilledVariant(MekanismBlocks.CREATIVE_CHEMICAL_TANK.getItemStack(), ((ChemicalStack)ingredient).getType());
    }

    public STACK normalizeIngredient(STACK ingredient) {
        return ChemicalUtil.copyWithAmount(ingredient, 1000L);
    }

    public boolean isValidIngredient(STACK ingredient) {
        return !((ChemicalStack)ingredient).isEmpty();
    }

    public Iterable<Integer> getColors(STACK ingredient) {
        if (this.colorHelper == null) {
            return super.getColors(ingredient);
        }
        Object chemical = ((ChemicalStack)ingredient).getType();
        return this.colorHelper.getColors(MekanismRenderer.getChemicalTexture(chemical), ((Chemical)chemical).getTint(), 1);
    }

    public STACK copyIngredient(STACK ingredient) {
        return ChemicalUtil.copy(ingredient);
    }

    public Stream<ResourceLocation> getTagStream(STACK ingredient) {
        return ((Chemical)((ChemicalStack)ingredient).getType()).getTags().map(TagKey::location);
    }

    protected abstract Registry<CHEMICAL> getRegistry();

    public Optional<ResourceLocation> getTagEquivalent(Collection<STACK> stacks) {
        if (stacks.size() < 2) {
            return Optional.empty();
        }
        Set values = stacks.stream().map(ChemicalStack::getType).collect(Collectors.toSet());
        int expected = values.size();
        if (expected != stacks.size()) {
            return Optional.empty();
        }
        return this.getRegistry().getTags().filter(pair -> {
            HolderSet.Named tag = (HolderSet.Named)pair.getSecond();
            if (tag.size() != expected) return false;
            if (!tag.stream().allMatch(arg_0 -> ((HolderSet.Named)tag).contains(arg_0))) return false;
            return true;
        }).map(pair -> ((TagKey)pair.getFirst()).location()).findFirst();
    }

    public String getErrorInfo(@Nullable STACK ingredient) {
        if (ingredient == null) {
            ingredient = this.getEmptyStack();
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(GasStack.class);
        Object chemical = ((ChemicalStack)ingredient).getType();
        toStringHelper.add(this.getType(), (Object)(((Chemical)chemical).isEmptyType() ? "none" : TextComponentUtil.build(chemical).getString()));
        if (!((ChemicalStack)ingredient).isEmpty()) {
            toStringHelper.add("Amount", ((ChemicalStack)ingredient).getAmount());
        }
        return toStringHelper.toString();
    }

    public static class SlurryStackHelper
    extends ChemicalStackHelper<Slurry, SlurryStack>
    implements IEmptySlurryProvider {
        @Override
        protected Registry<Slurry> getRegistry() {
            return MekanismAPI.SLURRY_REGISTRY;
        }

        @Override
        protected String getType() {
            return "Slurry";
        }

        public IIngredientType<SlurryStack> getIngredientType() {
            return MekanismJEI.TYPE_SLURRY;
        }
    }

    public static class PigmentStackHelper
    extends ChemicalStackHelper<Pigment, PigmentStack>
    implements IEmptyPigmentProvider {
        @Override
        protected Registry<Pigment> getRegistry() {
            return MekanismAPI.PIGMENT_REGISTRY;
        }

        @Override
        protected String getType() {
            return "Pigment";
        }

        public IIngredientType<PigmentStack> getIngredientType() {
            return MekanismJEI.TYPE_PIGMENT;
        }
    }

    public static class InfusionStackHelper
    extends ChemicalStackHelper<InfuseType, InfusionStack>
    implements IEmptyInfusionProvider {
        @Override
        protected String getType() {
            return "Infuse Type";
        }

        @Override
        protected Registry<InfuseType> getRegistry() {
            return MekanismAPI.INFUSE_TYPE_REGISTRY;
        }

        public IIngredientType<InfusionStack> getIngredientType() {
            return MekanismJEI.TYPE_INFUSION;
        }
    }

    public static class GasStackHelper
    extends ChemicalStackHelper<Gas, GasStack>
    implements IEmptyGasProvider {
        @Override
        protected String getType() {
            return "Gas";
        }

        @Override
        protected Registry<Gas> getRegistry() {
            return MekanismAPI.GAS_REGISTRY;
        }

        public IIngredientType<GasStack> getIngredientType() {
            return MekanismJEI.TYPE_GAS;
        }
    }
}

