/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei.machine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiHorizontalPowerBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.jei.HolderRecipeCategory;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.util.ChemicalUtil;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class ChemicalDissolutionRecipeCategory
extends HolderRecipeCategory<ChemicalDissolutionRecipe> {
    private final GuiGauge<?> inputGauge = this.addElement(GuiGasGauge.getDummy(GaugeType.STANDARD.with(DataType.INPUT), this, 7, 4));
    private final GuiGauge<?> outputGauge = this.addElement(GuiGasGauge.getDummy(GaugeType.STANDARD.with(DataType.OUTPUT), this, 131, 13));
    private final GuiSlot inputSlot = this.addSlot(SlotType.INPUT, 28, 36);

    public ChemicalDissolutionRecipeCategory(IGuiHelper helper, IRecipeViewerRecipeType<ChemicalDissolutionRecipe> recipeType) {
        super(helper, recipeType);
        this.addSlot(SlotType.EXTRA, 8, 65).with(SlotOverlay.MINUS);
        this.addSlot(SlotType.OUTPUT, 152, 55).with(SlotOverlay.PLUS);
        this.addSlot(SlotType.POWER, 152, 14).with(SlotOverlay.POWER);
        this.addSimpleProgress(ProgressType.LARGE_RIGHT, 64, 40);
        this.addElement(new GuiHorizontalPowerBar((IGuiWrapper)this, RecipeViewerUtils.FULL_BAR, 115, 75));
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, RecipeHolder<ChemicalDissolutionRecipe> recipeHolder, @NotNull IFocusGroup focusGroup) {
        ChemicalDissolutionRecipe recipe = (ChemicalDissolutionRecipe)recipeHolder.value();
        this.initItem(builder, RecipeIngredientRole.INPUT, this.inputSlot, recipe.getItemInput().getRepresentations());
        List<@NotNull TYPE> gasInputs = recipe.getGasInput().getRepresentations();
        List<GasStack> scaledGases = gasInputs.stream().map(gas -> new GasStack((GasStack)gas, gas.getAmount() * 100L)).toList();
        this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.INPUT, this.inputGauge, scaledGases);
        List<BoxedChemicalStack> outputDefinition = recipe.getOutputDefinition();
        if (outputDefinition.size() == 1) {
            BoxedChemicalStack output = outputDefinition.get(0);
            this.initChemicalOutput(builder, MekanismJEI.getIngredientType(output.getChemicalType()), Collections.singletonList(output.getChemicalStack()));
        } else {
            EnumMap<ChemicalType, List> outputs = new EnumMap<ChemicalType, List>(ChemicalType.class);
            for (BoxedChemicalStack boxedChemicalStack : outputDefinition) {
                outputs.computeIfAbsent(boxedChemicalStack.getChemicalType(), type -> new ArrayList());
            }
            for (BoxedChemicalStack boxedChemicalStack : outputDefinition) {
                ChemicalType chemicalType = boxedChemicalStack.getChemicalType();
                for (Map.Entry entry : outputs.entrySet()) {
                    if (entry.getKey() == chemicalType) {
                        ((List)entry.getValue()).add(boxedChemicalStack.getChemicalStack());
                        continue;
                    }
                    ((List)entry.getValue()).add(ChemicalUtil.getEmptyStack((ChemicalType)((Object)entry.getKey())));
                }
            }
            for (Map.Entry entry : outputs.entrySet()) {
                this.initChemicalOutput(builder, MekanismJEI.getIngredientType((ChemicalType)((Object)entry.getKey())), (List)entry.getValue());
            }
        }
    }

    private <STACK extends ChemicalStack<?>> void initChemicalOutput(IRecipeLayoutBuilder builder, IIngredientType<STACK> type, List<ChemicalStack<?>> stacks) {
        this.initChemical(builder, type, RecipeIngredientRole.OUTPUT, this.outputGauge, stacks);
    }
}

