/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei.machine;

import java.util.List;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiEmptyBar;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.jei.HolderRecipeCategory;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class ItemStackGasToItemStackRecipeCategory
extends HolderRecipeCategory<ItemStackGasToItemStackRecipe> {
    private final GuiBar<?> gasInput;
    private final GuiSlot input = this.addSlot(SlotType.INPUT, 64, 17);
    private final GuiSlot extra = this.addSlot(SlotType.EXTRA, 64, 53);
    private final GuiSlot output = this.addSlot(SlotType.OUTPUT, 116, 35);

    public ItemStackGasToItemStackRecipeCategory(IGuiHelper helper, IRecipeViewerRecipeType<ItemStackGasToItemStackRecipe> recipeType) {
        super(helper, recipeType);
        this.addSlot(SlotType.POWER, 39, 35).with(SlotOverlay.POWER);
        this.addElement(new GuiVerticalPowerBar((IGuiWrapper)this, RecipeViewerUtils.FULL_BAR, 164, 16));
        this.gasInput = this.addElement(new GuiEmptyBar(this, 68, 36, 6, 12));
        this.addSimpleProgress(ProgressType.BAR, 86, 38);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, RecipeHolder<ItemStackGasToItemStackRecipe> recipeHolder, @NotNull IFocusGroup focusGroup) {
        ItemStackGasToItemStackRecipe recipe = (ItemStackGasToItemStackRecipe)recipeHolder.value();
        this.initItem(builder, RecipeIngredientRole.INPUT, this.input, recipe.getItemInput().getRepresentations());
        List<GasStack> scaledGases = recipe.getChemicalInput().getRepresentations().stream().map(gas -> new GasStack((GasStack)gas, gas.getAmount() * 200L)).toList();
        this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.INPUT, this.gasInput, scaledGases);
        this.initItem(builder, RecipeIngredientRole.OUTPUT, this.output, recipe.getOutputDefinition());
        this.initItem(builder, RecipeIngredientRole.CATALYST, this.extra, RecipeViewerUtils.getStacksFor(recipe.getChemicalInput(), true));
    }
}

