/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei.machine;

import java.util.Collections;
import java.util.List;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiEnergyGauge;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.recipe_viewer.jei.HolderRecipeCategory;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.MekanismLang;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.util.text.EnergyDisplay;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class ItemStackToEnergyRecipeCategory
extends HolderRecipeCategory<ItemStackToEnergyRecipe> {
    private static final String INPUT = "input";
    private final GuiEnergyGauge gauge = this.addElement(GuiEnergyGauge.getDummy(GaugeType.STANDARD.with(DataType.OUTPUT), this, 133, 13));
    private final GuiSlot input = this.addSlot(SlotType.INPUT, 26, 36);

    public ItemStackToEnergyRecipeCategory(IGuiHelper helper, IRecipeViewerRecipeType<ItemStackToEnergyRecipe> recipeType) {
        super(helper, recipeType);
        this.addConstantProgress(ProgressType.LARGE_RIGHT, 64, 40);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, RecipeHolder<ItemStackToEnergyRecipe> recipeHolder, @NotNull IFocusGroup focusGroup) {
        this.initItem(builder, RecipeIngredientRole.INPUT, this.input, ((ItemStackToEnergyRecipe)recipeHolder.value()).getInput().getRepresentations()).setSlotName(INPUT);
    }

    @Override
    protected void renderElements(RecipeHolder<ItemStackToEnergyRecipe> recipeHolder, IRecipeSlotsView recipeSlotView, GuiGraphics guiGraphics, int x, int y) {
        super.renderElements(recipeHolder, recipeSlotView, guiGraphics, x, y);
        if (!this.getOutputEnergy(recipeHolder, recipeSlotView).isZero()) {
            this.gauge.renderContents(guiGraphics);
        }
    }

    public List<Component> getTooltipStrings(RecipeHolder<ItemStackToEnergyRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        FloatingLong energy;
        if (this.gauge.isMouseOver(mouseX, mouseY) && !(energy = this.getOutputEnergy(recipeHolder, recipeSlotsView)).isZero()) {
            Component energyOutput = EnergyDisplay.of(energy).getTextComponent();
            if (Minecraft.getInstance().options.advancedItemTooltips || Screen.hasShiftDown()) {
                return List.of(energyOutput, TextComponentUtil.build(ChatFormatting.DARK_GRAY, MekanismLang.JEI_RECIPE_ID.translate(recipeHolder.id())));
            }
            return Collections.singletonList(energyOutput);
        }
        return Collections.emptyList();
    }

    private FloatingLong getOutputEnergy(RecipeHolder<ItemStackToEnergyRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView) {
        ItemStack displayedIngredient = this.getDisplayedStack(recipeSlotsView, INPUT, VanillaTypes.ITEM_STACK, ItemStack.EMPTY);
        if (displayedIngredient.isEmpty()) {
            return FloatingLong.ZERO;
        }
        return ((ItemStackToEnergyRecipe)recipeHolder.value()).getOutput(displayedIngredient);
    }
}

