/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.recipe;

import java.util.HashMap;
import java.util.Map;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registries.MekanismGases;
import mekanism.common.util.HeatUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import org.jetbrains.annotations.Nullable;

public record BoilerRecipeViewerRecipe(@Nullable ChemicalStackIngredient.GasStackIngredient superHeatedCoolant, FluidStackIngredient water, GasStack steam, GasStack cooledCoolant, double temperature) {
    public static Map<ResourceLocation, BoilerRecipeViewerRecipe> getBoilerRecipes() {
        int waterAmount = 1;
        double waterToSteamEfficiency = HeatUtils.getWaterThermalEnthalpy() / HeatUtils.getSteamEnergyEfficiency();
        HashMap<ResourceLocation, BoilerRecipeViewerRecipe> recipes = new HashMap<ResourceLocation, BoilerRecipeViewerRecipe>();
        double temperature = (double)waterAmount * waterToSteamEfficiency / (50.0 * MekanismConfig.general.boilerWaterConductivity.get()) + HeatUtils.BASE_BOIL_TEMP;
        recipes.put(RecipeViewerUtils.synthetic(Mekanism.rl("water"), "boiler"), new BoilerRecipeViewerRecipe(null, (FluidStackIngredient)IngredientCreatorAccess.fluid().from(FluidTags.WATER, waterAmount), MekanismGases.STEAM.getStack(waterAmount), GasStack.EMPTY, temperature));
        for (Gas gas : MekanismAPI.GAS_REGISTRY) {
            GasAttributes.HeatedCoolant heatedCoolant = gas.get(GasAttributes.HeatedCoolant.class);
            if (heatedCoolant == null) continue;
            Gas cooledCoolant = heatedCoolant.getCooledGas();
            long coolantAmount = Math.round((double)waterAmount * waterToSteamEfficiency / heatedCoolant.getThermalEnthalpy());
            recipes.put(RecipeViewerUtils.synthetic(gas.getRegistryName(), "boiler", "mekanism"), new BoilerRecipeViewerRecipe(IngredientCreatorAccess.gas().from((IChemicalProvider<Gas>)gas, coolantAmount), (FluidStackIngredient)IngredientCreatorAccess.fluid().from(FluidTags.WATER, waterAmount), MekanismGases.STEAM.getStack(waterAmount), cooledCoolant.getStack(coolantAmount), HeatUtils.BASE_BOIL_TEMP));
        }
        return recipes;
    }
}

