/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import mekanism.client.render.MekanismShaders;
import net.minecraft.Util;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class MekanismRenderType
extends RenderType {
    private static final RenderStateShard.TransparencyStateShard BLADE_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("mek_blade_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    private static final RenderStateShard.TransparencyStateShard PARTICLE_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("mek_particle_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }, RenderSystem::disableBlend);
    private static final RenderStateShard.ShaderStateShard PARTICLE_SHADER = new RenderStateShard.ShaderStateShard(GameRenderer::getParticleShader);
    public static final RenderType MEK_LIGHTNING = MekanismRenderType.create((String)"mek_lightning", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_LIGHTNING_SHADER).setTransparencyState(LIGHTNING_TRANSPARENCY).createCompositeState(false));
    public static final Function<ResourceLocation, RenderType> STANDARD = Util.memoize(resourceLocation -> MekanismRenderType.createStandard("mek_standard", resourceLocation, UnaryOperator.identity(), false));
    public static final Function<ResourceLocation, RenderType> STANDARD_TRANSLUCENT_TARGET = Util.memoize(resourceLocation -> MekanismRenderType.createStandard("mek_standard_translucent_target", resourceLocation, state -> state.setOutputState(RenderType.TRANSLUCENT_TARGET), true));
    public static final Function<ResourceLocation, RenderType> ALARM = Util.memoize(resourceLocation -> MekanismRenderType.createStandard("mek_alarm", resourceLocation, state -> state.setCullState(NO_CULL).setOutputState(RenderType.TRANSLUCENT_TARGET), true));
    public static final Function<ResourceLocation, RenderType> JETPACK_GLASS = Util.memoize(resourceLocation -> MekanismRenderType.createStandard("mek_jetpack_glass", resourceLocation, state -> state.setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, true, false)), false));
    public static final Function<ResourceLocation, RenderType> BLADE = Util.memoize(resourceLocation -> {
        RenderType.CompositeState state = RenderType.CompositeState.builder().setShaderState(RENDERTYPE_EYES_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, false, false)).setTransparencyState(BLADE_TRANSPARENCY).createCompositeState(true);
        return MekanismRenderType.create((String)"mek_blade", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    });
    public static final Function<ResourceLocation, RenderType> FLAME = Util.memoize(resourceLocation -> {
        RenderType.CompositeState state = RenderType.CompositeState.builder().setShaderState(MekanismShaders.FLAME.shard).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, false, false)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).createCompositeState(true);
        return MekanismRenderType.create((String)"mek_flame", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    });
    public static final RenderType NUTRITIONAL_PARTICLE = MekanismRenderType.create((String)"mek_nutritional_particle", (VertexFormat)DefaultVertexFormat.PARTICLE, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(PARTICLE_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET).setTransparencyState(PARTICLE_TRANSPARENCY).setLightmapState(LIGHTMAP).createCompositeState(false));
    public static final RenderType MEKASUIT = MekanismRenderType.create((String)"mekasuit", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)131072, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(MekanismShaders.MEKASUIT.shard).setTextureState((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET).setLightmapState(LIGHTMAP).setOverlayState(OVERLAY).createCompositeState(true));
    public static final Function<ResourceLocation, RenderType> SPS = Util.memoize(resourceLocation -> {
        RenderType.CompositeState state = RenderType.CompositeState.builder().setShaderState(MekanismShaders.SPS.shard).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, false, false)).setTransparencyState(LIGHTNING_TRANSPARENCY).setOutputState(RenderType.TRANSLUCENT_TARGET).createCompositeState(true);
        return MekanismRenderType.create((String)"mek_sps", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)state);
    });

    private MekanismRenderType(String name, VertexFormat format, VertexFormat.Mode mode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setupState, Runnable clearState) {
        super(name, format, mode, bufferSize, affectsCrumbling, sortOnUpload, setupState, clearState);
    }

    private static RenderType createStandard(String name, ResourceLocation resourceLocation, UnaryOperator<RenderType.CompositeState.CompositeStateBuilder> stateModifier, boolean sortOnUpload) {
        RenderType.CompositeState state = ((RenderType.CompositeState.CompositeStateBuilder)stateModifier.apply(RenderType.CompositeState.builder().setShaderState(RENDERTYPE_EYES_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, false, false)).setTransparencyState(TRANSLUCENT_TRANSPARENCY))).createCompositeState(true);
        return MekanismRenderType.create((String)name, (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)sortOnUpload, (RenderType.CompositeState)state);
    }
}

