/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.SupportsColorMap;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.client.SpecialColors;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.RenderTickHandler;
import mekanism.client.render.data.FluidRenderData;
import mekanism.client.render.data.ValveRenderData;
import mekanism.client.render.lib.ColorAtlas;
import mekanism.client.render.tileentity.RenderDigitalMiner;
import mekanism.client.render.tileentity.RenderDimensionalStabilizer;
import mekanism.client.render.tileentity.RenderFluidTank;
import mekanism.client.render.tileentity.RenderNutritionalLiquifier;
import mekanism.client.render.tileentity.RenderPigmentMixer;
import mekanism.client.render.tileentity.RenderSeismicVibrator;
import mekanism.client.render.tileentity.RenderTeleporter;
import mekanism.client.render.transmitter.RenderLogisticalTransporter;
import mekanism.client.render.transmitter.RenderMechanicalPipe;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.Mekanism;
import mekanism.common.lib.Color;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="mekanism", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class MekanismRenderer {
    public static TextureAtlasSprite energyIcon;
    public static TextureAtlasSprite heatIcon;
    public static TextureAtlasSprite whiteIcon;
    public static TextureAtlasSprite teleporterPortal;
    public static TextureAtlasSprite redstonePulse;
    public static final Map<TransmissionType, TextureAtlasSprite> overlays;

    public static TextureAtlasSprite getBaseFluidTexture(@NotNull Fluid fluid, @NotNull FluidTextureType type) {
        IClientFluidTypeExtensions properties = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation spriteLocation = type == FluidTextureType.STILL ? properties.getStillTexture() : properties.getFlowingTexture();
        return MekanismRenderer.getSprite(spriteLocation);
    }

    public static TextureAtlasSprite getFluidTexture(@NotNull FluidStack fluidStack, @NotNull FluidTextureType type) {
        IClientFluidTypeExtensions properties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation spriteLocation = type == FluidTextureType.STILL ? properties.getStillTexture(fluidStack) : properties.getFlowingTexture(fluidStack);
        return MekanismRenderer.getSprite(spriteLocation);
    }

    public static TextureAtlasSprite getChemicalTexture(@NotNull Chemical<?> chemical) {
        return MekanismRenderer.getSprite(chemical.getIcon());
    }

    public static TextureAtlasSprite getSprite(ResourceLocation spriteLocation) {
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(spriteLocation);
    }

    public static void renderObject(@Nullable Model3D object, @NotNull PoseStack matrix, VertexConsumer buffer, int argb, int light, int overlay, RenderResizableCuboid.FaceDisplay faceDisplay, Camera camera, BlockPos renderPos) {
        if (object != null) {
            RenderResizableCuboid.renderCube(object, matrix, buffer, argb, light, overlay, faceDisplay, camera, Vec3.atLowerCornerOf((Vec3i)renderPos));
        }
    }

    public static void renderObject(@Nullable Model3D object, @NotNull PoseStack matrix, VertexConsumer buffer, int[] colors, int light, int overlay, RenderResizableCuboid.FaceDisplay faceDisplay, Camera camera) {
        if (object != null) {
            RenderResizableCuboid.renderCube(object, matrix, buffer, colors, light, overlay, faceDisplay, camera, null);
        }
    }

    public static void renderValves(PoseStack matrix, VertexConsumer buffer, Set<IValveHandler.ValveData> valves, FluidRenderData data, float fluidHeight, BlockPos pos, int glow, int overlay, RenderResizableCuboid.FaceDisplay faceDisplay, Camera camera) {
        for (IValveHandler.ValveData valveData : valves) {
            ValveRenderData valveRenderData = ValveRenderData.get(data, valveData);
            Model3D valveModel = ModelRenderer.getValveModel(valveRenderData, fluidHeight);
            if (valveModel == null) continue;
            matrix.pushPose();
            matrix.translate((float)(valveData.location.getX() - pos.getX()), (float)(valveData.location.getY() - pos.getY()), (float)(valveData.location.getZ() - pos.getZ()));
            MekanismRenderer.renderObject(valveModel, matrix, buffer, valveRenderData.getColorARGB(), glow, overlay, faceDisplay, camera, valveData.location);
            matrix.popPose();
        }
    }

    public static void resetColor(GuiGraphics guiGraphics) {
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static float getRed(int color) {
        return (float)FastColor.ARGB32.red((int)color) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)FastColor.ARGB32.green((int)color) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)FastColor.ARGB32.blue((int)color) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)FastColor.ARGB32.alpha((int)color) / 255.0f;
    }

    public static void color(GuiGraphics guiGraphics, int color) {
        guiGraphics.setColor(MekanismRenderer.getRed(color), MekanismRenderer.getGreen(color), MekanismRenderer.getBlue(color), MekanismRenderer.getAlpha(color));
    }

    public static void color(GuiGraphics guiGraphics, ColorAtlas.ColorRegistryObject colorRO) {
        MekanismRenderer.color(guiGraphics, colorRO.get());
    }

    public static void color(GuiGraphics guiGraphics, Color color) {
        guiGraphics.setColor(color.rf(), color.gf(), color.bf(), color.af());
    }

    public static void color(GuiGraphics guiGraphics, @NotNull FluidStack fluid) {
        if (!fluid.isEmpty()) {
            MekanismRenderer.color(guiGraphics, IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getTintColor(fluid));
        }
    }

    public static void color(GuiGraphics guiGraphics, @NotNull ChemicalStack<?> chemicalStack) {
        if (!chemicalStack.isEmpty()) {
            MekanismRenderer.color(guiGraphics, chemicalStack.getType());
        }
    }

    public static void color(GuiGraphics guiGraphics, @NotNull Chemical<?> chemical) {
        if (!chemical.isEmptyType()) {
            int color = chemical.getTint();
            guiGraphics.setColor(MekanismRenderer.getRed(color), MekanismRenderer.getGreen(color), MekanismRenderer.getBlue(color), 1.0f);
        }
    }

    public static void color(GuiGraphics guiGraphics, @Nullable SupportsColorMap color) {
        MekanismRenderer.color(guiGraphics, color, 1.0f);
    }

    public static void color(GuiGraphics guiGraphics, @Nullable SupportsColorMap color, float alpha) {
        if (color != null) {
            guiGraphics.setColor(color.getColor(0), color.getColor(1), color.getColor(2), alpha);
        }
    }

    public static int getColorARGB(SupportsColorMap color, float alpha) {
        return MekanismRenderer.getColorARGB(color.getRgbCode()[0], color.getRgbCode()[1], color.getRgbCode()[2], alpha);
    }

    public static int getColorARGB(@NotNull FluidStack fluidStack) {
        return IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
    }

    public static int getColorARGB(@NotNull FluidStack fluidStack, float fluidScale) {
        if (fluidStack.isEmpty()) {
            return -1;
        }
        int color = MekanismRenderer.getColorARGB(fluidStack);
        if (MekanismUtils.lighterThanAirGas(fluidStack)) {
            return MekanismRenderer.getColorARGB(FastColor.ARGB32.red((int)color), FastColor.ARGB32.green((int)color), FastColor.ARGB32.blue((int)color), Math.min(1.0f, fluidScale + 0.2f));
        }
        return color;
    }

    public static int getColorARGB(@NotNull ChemicalStack<?> stack, float scale, boolean gaseous) {
        return MekanismRenderer.getColorARGB(stack.getType(), scale, gaseous);
    }

    public static int getColorARGB(@NotNull Chemical<?> chemical, float scale, boolean gaseous) {
        if (chemical.isEmptyType()) {
            return -1;
        }
        int color = chemical.getTint();
        return MekanismRenderer.getColorARGB(FastColor.ARGB32.red((int)color), FastColor.ARGB32.green((int)color), FastColor.ARGB32.blue((int)color), gaseous ? Math.min(1.0f, scale + 0.2f) : 1.0f);
    }

    public static int getColorARGB(float red, float green, float blue, float alpha) {
        return MekanismRenderer.getColorARGB((int)(255.0f * red), (int)(255.0f * green), (int)(255.0f * blue), alpha);
    }

    public static int getColorARGB(int red, int green, int blue, float alpha) {
        if (alpha < 0.0f) {
            alpha = 0.0f;
        } else if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        return FastColor.ARGB32.color((int)((int)(255.0f * alpha)), (int)red, (int)green, (int)blue);
    }

    public static int calculateGlowLight(int combinedLight, @NotNull FluidStack fluid) {
        return fluid.isEmpty() ? combinedLight : MekanismRenderer.calculateGlowLight(combinedLight, fluid.getFluidType().getLightLevel(fluid));
    }

    public static int calculateGlowLight(int combinedLight, int glow) {
        return combinedLight & 0xFFFF0000 | Math.max(Math.min(glow, 15) << 4, combinedLight & 0xFFFF);
    }

    public static void renderColorOverlay(GuiGraphics guiGraphics, int x, int y, int color) {
        guiGraphics.fill(RenderType.guiOverlay(), x, y, guiGraphics.guiWidth(), guiGraphics.guiHeight(), color);
    }

    public static float getPartialTick() {
        return Minecraft.getInstance().getFrameTime();
    }

    public static void rotate(PoseStack matrix, Direction facing, float north, float south, float west, float east) {
        switch (facing) {
            case NORTH: {
                matrix.mulPose(Axis.YP.rotationDegrees(north));
                break;
            }
            case SOUTH: {
                matrix.mulPose(Axis.YP.rotationDegrees(south));
                break;
            }
            case WEST: {
                matrix.mulPose(Axis.YP.rotationDegrees(west));
                break;
            }
            case EAST: {
                matrix.mulPose(Axis.YP.rotationDegrees(east));
            }
        }
    }

    private static <T extends Enum<T>> void parseColorAtlas(ResourceLocation rl, T[] elements) {
        List<Color> parsed = ColorAtlas.load(rl, elements.length);
        if (parsed.size() < elements.length) {
            Mekanism.logger.error("Failed to parse color atlas: {}.", (Object)rl);
            return;
        }
        for (int i = 0; i < elements.length; ++i) {
            Color color = parsed.get(i);
            if (color == null) continue;
            ((SupportsColorMap)elements[i]).setColorFromAtlas(color.rgbArray());
        }
    }

    @SubscribeEvent
    public static void onStitch(TextureAtlasStitchedEvent event) {
        TextureAtlas map = event.getAtlas();
        if (!map.location().equals((Object)TextureAtlas.LOCATION_BLOCKS)) {
            return;
        }
        for (TransmissionType type : EnumUtils.TRANSMISSION_TYPES) {
            overlays.put(type, map.getSprite(Mekanism.rl("block/overlay/" + type.getTransmission() + "_overlay")));
        }
        whiteIcon = map.getSprite(Mekanism.rl("block/overlay/overlay_white"));
        energyIcon = map.getSprite(Mekanism.rl("liquid/energy"));
        heatIcon = map.getSprite(Mekanism.rl("liquid/heat"));
        redstonePulse = map.getSprite(Mekanism.rl("icon/redstone_control_pulse"));
        teleporterPortal = map.getSprite(Mekanism.rl("block/teleporter_portal"));
        RenderLogisticalTransporter.onStitch(map);
        RenderTransmitterBase.onStitch();
        ModelRenderer.resetCachedModels();
        RenderDigitalMiner.resetCachedVisuals();
        RenderDimensionalStabilizer.resetCachedVisuals();
        RenderFluidTank.resetCachedModels();
        RenderNutritionalLiquifier.resetCachedModels();
        RenderPigmentMixer.resetCached();
        RenderMechanicalPipe.onStitch();
        RenderSeismicVibrator.resetCached();
        RenderTickHandler.resetCached();
        RenderTeleporter.resetCachedModels();
        MekanismRenderer.parseColorAtlas((ResourceLocation)Mekanism.rl("textures/colormap/primary.png"), (Enum[])EnumUtils.COLORS);
        MekanismRenderer.parseColorAtlas((ResourceLocation)Mekanism.rl("textures/colormap/tiers.png"), (Enum[])EnumUtils.TIERS);
        SpecialColors.GUI_OBJECTS.parse(Mekanism.rl("textures/colormap/gui_objects.png"));
        SpecialColors.GUI_TEXT.parse(Mekanism.rl("textures/colormap/gui_text.png"));
        GuiElementHolder.updateBackgroundColor();
    }

    static {
        overlays = new EnumMap<TransmissionType, TextureAtlasSprite>(TransmissionType.class);
    }

    public static enum FluidTextureType {
        STILL,
        FLOWING;

    }

    public static class Model3D {
        public float minX;
        public float minY;
        public float minZ;
        public float maxX;
        public float maxY;
        public float maxZ;
        private final TextureAtlasSprite[] textures = new TextureAtlasSprite[6];
        private final boolean[] renderSides = new boolean[]{true, true, true, true, true, true};

        public Model3D setSideRender(Predicate<Direction> shouldRender) {
            for (Direction direction : EnumUtils.DIRECTIONS) {
                this.setSideRender(direction, shouldRender.test(direction));
            }
            return this;
        }

        public Model3D setSideRender(Direction side, boolean value) {
            this.renderSides[side.ordinal()] = value;
            return this;
        }

        public Model3D copy() {
            Model3D copy = new Model3D();
            System.arraycopy(this.textures, 0, copy.textures, 0, this.textures.length);
            System.arraycopy(this.renderSides, 0, copy.renderSides, 0, this.renderSides.length);
            return copy.bounds(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }

        @Nullable
        public TextureAtlasSprite getSpriteToRender(Direction side) {
            int ordinal = side.ordinal();
            return this.renderSides[ordinal] ? this.textures[ordinal] : null;
        }

        public Model3D shrink(float amount) {
            return this.grow(-amount);
        }

        public Model3D grow(float amount) {
            return this.bounds(this.minX - amount, this.minY - amount, this.minZ - amount, this.maxX + amount, this.maxY + amount, this.maxZ + amount);
        }

        public Model3D xBounds(float min, float max) {
            this.minX = min;
            this.maxX = max;
            return this;
        }

        public Model3D yBounds(float min, float max) {
            this.minY = min;
            this.maxY = max;
            return this;
        }

        public Model3D zBounds(float min, float max) {
            this.minZ = min;
            this.maxZ = max;
            return this;
        }

        public Model3D bounds(float min, float max) {
            return this.bounds(min, min, min, max, max, max);
        }

        public Model3D bounds(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            return this.xBounds(minX, maxX).yBounds(minY, maxY).zBounds(minZ, maxZ);
        }

        public Model3D prepSingleFaceModelSize(Direction face) {
            this.bounds(0.0f, 1.0f);
            return switch (face) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN -> this.yBounds(-0.01f, -0.001f);
                case Direction.UP -> this.yBounds(1.001f, 1.01f);
                case Direction.NORTH -> this.zBounds(-0.01f, -0.001f);
                case Direction.SOUTH -> this.zBounds(1.001f, 1.01f);
                case Direction.WEST -> this.xBounds(-0.01f, -0.001f);
                case Direction.EAST -> this.xBounds(1.001f, 1.01f);
            };
        }

        public Model3D prepFlowing(@NotNull FluidStack fluid) {
            TextureAtlasSprite still = MekanismRenderer.getFluidTexture(fluid, FluidTextureType.STILL);
            TextureAtlasSprite flowing = MekanismRenderer.getFluidTexture(fluid, FluidTextureType.FLOWING);
            return this.setTextures(still, still, flowing, flowing, flowing, flowing);
        }

        public Model3D setTexture(Direction side, @Nullable TextureAtlasSprite sprite) {
            this.textures[side.ordinal()] = sprite;
            return this;
        }

        public Model3D setTexture(TextureAtlasSprite tex) {
            Arrays.fill(this.textures, tex);
            return this;
        }

        public Model3D setTextures(TextureAtlasSprite down, TextureAtlasSprite up, TextureAtlasSprite north, TextureAtlasSprite south, TextureAtlasSprite west, TextureAtlasSprite east) {
            this.textures[0] = down;
            this.textures[1] = up;
            this.textures[2] = north;
            this.textures[3] = south;
            this.textures[4] = west;
            this.textures[5] = east;
            return this;
        }

        public static interface ModelBoundsSetter {
            public Model3D set(float var1, float var2);
        }
    }

    public static class LazyModel
    implements Supplier<Model3D> {
        private final Supplier<Model3D> supplier;
        @Nullable
        private Model3D model;

        public LazyModel(Supplier<Model3D> supplier) {
            this.supplier = supplier;
        }

        public void reset() {
            this.model = null;
        }

        @Override
        public Model3D get() {
            if (this.model == null) {
                this.model = this.supplier.get();
            }
            return this.model;
        }
    }
}

