/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.data;

import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.client.render.data.ChemicalRenderData;
import mekanism.client.render.data.FluidRenderData;
import mekanism.common.lib.multiblock.MultiblockData;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class RenderData {
    public final BlockPos location;
    public final int height;
    public final int length;
    public final int width;

    protected RenderData(BlockPos renderLocation, int width, int height, int length) {
        this.location = renderLocation;
        this.width = width;
        this.height = height;
        this.length = length;
    }

    public abstract TextureAtlasSprite getTexture();

    public abstract boolean isGaseous();

    public abstract int getColorARGB(float var1);

    public int calculateGlowLight(int light) {
        return light;
    }

    public int hashCode() {
        return Objects.hash(this.height, this.length, this.width);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof RenderData)) return false;
        RenderData data = (RenderData)object;
        if (data.height != this.height) return false;
        if (data.length != this.length) return false;
        if (data.width != this.width) return false;
        return true;
    }

    public static class Builder<DATA_TYPE extends RenderData> {
        @Nullable
        private final Chemical<?> chemical;
        private final FluidStack fluid;
        @Nullable
        private BlockPos location;
        private int height;
        private int length;
        private int width;

        private Builder(@Nullable Chemical<?> chemical, FluidStack fluid) {
            this.chemical = chemical;
            this.fluid = fluid;
        }

        public static <CHEMICAL extends Chemical<CHEMICAL>> Builder<ChemicalRenderData<CHEMICAL>> create(ChemicalStack<CHEMICAL> chemical) {
            if (chemical.isEmpty()) {
                throw new IllegalArgumentException("Chemical may not be empty");
            }
            return new Builder<ChemicalRenderData<CHEMICAL>>((Chemical<?>)chemical.getType(), FluidStack.EMPTY);
        }

        public static Builder<FluidRenderData> create(FluidStack fluid) {
            if (fluid.isEmpty()) {
                throw new IllegalArgumentException("Fluid may not be empty");
            }
            return new Builder<FluidRenderData>(null, fluid);
        }

        public Builder<DATA_TYPE> location(BlockPos renderLocation) {
            this.location = renderLocation;
            return this;
        }

        public Builder<DATA_TYPE> height(int height) {
            this.height = height;
            return this;
        }

        public Builder<DATA_TYPE> length(int length) {
            this.length = length;
            return this;
        }

        public Builder<DATA_TYPE> width(int width) {
            this.width = width;
            return this;
        }

        public Builder<DATA_TYPE> dimensions(int width, int height, int length) {
            return this.width(width).height(height).length(length);
        }

        public Builder<DATA_TYPE> of(MultiblockData multiblock) {
            return this.location(Objects.requireNonNull(multiblock.renderLocation, "Render location may not be null.")).height(multiblock.height() - 2).length(multiblock.length()).width(multiblock.width());
        }

        public DATA_TYPE build() {
            RenderData data;
            if (this.location == null) {
                throw new IllegalStateException("Incomplete render data builder, no render location set.");
            }
            if (!this.fluid.isEmpty()) {
                data = new FluidRenderData(this.location, this.width, this.height, this.length, this.fluid);
            } else {
                Chemical<?> chemical = this.chemical;
                if (chemical instanceof Gas) {
                    Gas gas = (Gas)chemical;
                    data = new ChemicalRenderData.GasRenderData(this.location, this.width, this.height, this.length, gas);
                } else {
                    chemical = this.chemical;
                    if (chemical instanceof InfuseType) {
                        InfuseType infuseType = (InfuseType)chemical;
                        data = new ChemicalRenderData.InfusionRenderData(this.location, this.width, this.height, this.length, infuseType);
                    } else {
                        chemical = this.chemical;
                        if (chemical instanceof Pigment) {
                            Pigment pigment = (Pigment)chemical;
                            data = new ChemicalRenderData.PigmentRenderData(this.location, this.width, this.height, this.length, pigment);
                        } else {
                            chemical = this.chemical;
                            if (chemical instanceof Slurry) {
                                Slurry slurry = (Slurry)chemical;
                                data = new ChemicalRenderData.SlurryRenderData(this.location, this.width, this.height, this.length, slurry);
                            } else {
                                throw new IllegalStateException("Incomplete render data builder, missing or unknown chemical or fluid.");
                            }
                        }
                    }
                }
            }
            return (DATA_TYPE)data;
        }
    }
}

