/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mekanism.client.render.MekanismRenderType;
import mekanism.common.entity.EntityFlame;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class RenderFlame
extends EntityRenderer<EntityFlame> {
    public RenderFlame(EntityRendererProvider.Context context) {
        super(context);
    }

    public boolean shouldRender(EntityFlame flame, @NotNull Frustum camera, double camX, double camY, double camZ) {
        return flame.tickCount > 0 && super.shouldRender((Entity)flame, camera, camX, camY, camZ);
    }

    public void render(@NotNull EntityFlame flame, float entityYaw, float partialTick, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light) {
        float alpha = ((float)flame.tickCount + partialTick) / 80.0f;
        float actualAlpha = 1.0f - alpha;
        if (actualAlpha <= 0.0f) {
            return;
        }
        float size = (float)Math.pow(2.0f * alpha, 2.0);
        float f5 = 0.15625f;
        float scale = 0.05625f * (0.8f + size);
        int alphaColor = (int)(actualAlpha * 255.0f);
        matrix.pushPose();
        matrix.mulPose(Axis.YP.rotationDegrees(flame.yRotO + (flame.getYRot() - flame.yRotO) * partialTick - 90.0f));
        matrix.mulPose(Axis.ZP.rotationDegrees(flame.xRotO + (flame.getXRot() - flame.xRotO) * partialTick));
        matrix.mulPose(Axis.XP.rotationDegrees(45.0f));
        matrix.scale(scale, scale, scale);
        matrix.translate(-4.0f, 0.0f, 0.0f);
        VertexConsumer builder = renderer.getBuffer(MekanismRenderType.FLAME.apply(this.getTextureLocation(flame)));
        for (int j = 0; j < 4; ++j) {
            matrix.mulPose(Axis.XP.rotationDegrees(90.0f));
            builder.normal(matrix.last().normal(), 0.0f, 0.0f, scale);
            Matrix4f matrix4f = matrix.last().pose();
            builder.vertex(matrix4f, -8.0f, -2.0f, 0.0f).color(255, 255, 255, alphaColor).uv(0.0f, 0.0f).endVertex();
            builder.vertex(matrix4f, 8.0f, -2.0f, 0.0f).color(255, 255, 255, alphaColor).uv(0.5f, 0.0f).endVertex();
            builder.vertex(matrix4f, 8.0f, 2.0f, 0.0f).color(255, 255, 255, alphaColor).uv(0.5f, f5).endVertex();
            builder.vertex(matrix4f, -8.0f, 2.0f, 0.0f).color(255, 255, 255, alphaColor).uv(0.0f, f5).endVertex();
        }
        matrix.popPose();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull EntityFlame entity) {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "flame.png");
    }
}

