/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mekanism.client.RobitSpriteUploader;
import mekanism.client.model.MekanismModelCache;
import mekanism.common.Mekanism;
import mekanism.common.entity.EntityRobit;
import mekanism.common.registries.MekanismRobitSkins;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderRobit
extends MobRenderer<EntityRobit, RobitModelWrapper> {
    public RenderRobit(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new RobitModelWrapper(), 0.5f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull EntityRobit robit) {
        return RobitSpriteUploader.ATLAS_LOCATION;
    }

    public static class RobitModelWrapper
    extends EntityModel<EntityRobit> {
        @Nullable
        private EntityRobit robit;

        RobitModelWrapper() {
        }

        public void setupAnim(@NotNull EntityRobit robit, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.robit = robit;
        }

        public void renderToBuffer(@NotNull PoseStack matrix, @NotNull VertexConsumer builder, int light, int overlayLight, float red, float green, float blue, float alpha) {
            if (this.robit == null) {
                return;
            }
            MekanismRobitSkins.SkinLookup skinLookup = MekanismRobitSkins.lookup(this.robit.level().registryAccess(), this.robit.getSkin());
            BakedModel model = MekanismModelCache.INSTANCE.getRobitSkin(skinLookup);
            if (model == null) {
                Mekanism.logger.warn("Robit with skin: {} does not have a model. If this happened during a resource reload this can be ignored.", (Object)skinLookup.location());
            } else {
                matrix.pushPose();
                matrix.mulPose(Axis.XP.rotationDegrees(180.0f));
                matrix.translate(-0.5, -1.5, -0.5);
                PoseStack.Pose last = matrix.last();
                for (BakedQuad quad : model.getQuads(null, null, this.robit.level().random, this.robit.getModelData(), null)) {
                    builder.putBulkData(last, quad, red, green, blue, alpha, light, overlayLight, false);
                }
                matrix.popPose();
            }
            this.robit = null;
        }
    }
}

