/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.hud;

import com.mojang.blaze3d.vertex.PoseStack;
import mekanism.client.gui.GuiUtils;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.lib.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.overlay.ExtendedGui;
import net.neoforged.neoforge.client.gui.overlay.IGuiOverlay;

public class MekanismStatusOverlay
implements IGuiOverlay {
    public static final MekanismStatusOverlay INSTANCE = new MekanismStatusOverlay();
    private static final int BASE_TIMER = 100;
    private int modeSwitchTimer = 0;
    private long lastTick;

    private MekanismStatusOverlay() {
    }

    public void setTimer() {
        this.modeSwitchTimer = 100;
    }

    public void render(ExtendedGui gui, GuiGraphics guiGraphics, float partialTicks, int screenWidth, int screenHeight) {
        Minecraft minecraft = gui.getMinecraft();
        if (!minecraft.options.hideGui && this.modeSwitchTimer > 1 && minecraft.player != null) {
            Component scrollTextComponent;
            ItemStack stack = minecraft.player.getMainHandItem();
            if (IModeItem.isModeItem(stack, EquipmentSlot.MAINHAND) && (scrollTextComponent = ((IModeItem)stack.getItem()).getScrollTextComponent(stack)) != null) {
                Color color = Color.rgbad(1.0, 1.0, 1.0, (float)this.modeSwitchTimer / 100.0f);
                Font font = gui.getFont();
                int componentWidth = font.width((FormattedText)scrollTextComponent);
                int targetShift = Math.max(59, Math.max(gui.leftHeight, gui.rightHeight));
                if (minecraft.gameMode != null && !minecraft.gameMode.canHurtPlayer()) {
                    targetShift -= 14;
                } else if (gui.overlayMessageTime > 0) {
                    targetShift += 14;
                }
                PoseStack pose = guiGraphics.pose();
                pose.pushPose();
                pose.translate((float)(screenWidth - componentWidth) / 2.0f, (float)(screenHeight - (targetShift += 13)), 0.0f);
                GuiUtils.drawBackdrop(guiGraphics, minecraft, 0, 0, componentWidth, color.a());
                guiGraphics.drawString(font, scrollTextComponent, 0, 0, color.argb());
                pose.popPose();
            }
            if (this.lastTick != minecraft.player.level().getGameTime()) {
                this.lastTick = minecraft.player.level().getGameTime();
                --this.modeSwitchTimer;
            }
        }
    }
}

