/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.model.ModelIndustrialAlarm;
import mekanism.client.render.RenderTickHandler;
import mekanism.client.render.tileentity.ModelTileEntityRenderer;
import mekanism.common.tile.TileEntityIndustrialAlarm;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Vec3i;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class RenderIndustrialAlarm
extends ModelTileEntityRenderer<TileEntityIndustrialAlarm, ModelIndustrialAlarm> {
    private static final float ROTATE_SPEED = 10.0f;

    public RenderIndustrialAlarm(BlockEntityRendererProvider.Context context) {
        super(context, ModelIndustrialAlarm::new);
    }

    @Override
    protected void render(final TileEntityIndustrialAlarm tile, float partialTicks, PoseStack matrix, MultiBufferSource renderer, int light, final int overlayLight, ProfilerFiller profiler) {
        RenderTickHandler.addTransparentRenderer(new RenderTickHandler.LazyRender(){

            @Override
            public void render(Camera camera, VertexConsumer buffer, PoseStack poseStack, int renderTick, float partialTick, ProfilerFiller profiler) {
                float rot = ((float)renderTick + partialTick) * 10.0f % 360.0f;
                Vec3 renderPos = Vec3.atBottomCenterOf((Vec3i)tile.getBlockPos());
                poseStack.pushPose();
                Vec3 offset = renderPos.subtract(camera.getPosition());
                poseStack.translate(offset.x, offset.y, offset.z);
                switch (tile.getDirection()) {
                    case DOWN: {
                        poseStack.translate(0.0f, 1.0f, 0.0f);
                        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                        break;
                    }
                    case NORTH: {
                        poseStack.translate(0.0, 0.5, 0.5);
                        poseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
                        break;
                    }
                    case SOUTH: {
                        poseStack.translate(0.0, 0.5, -0.5);
                        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                        break;
                    }
                    case EAST: {
                        poseStack.translate(-0.5, 0.5, 0.0);
                        poseStack.mulPose(Axis.ZN.rotationDegrees(90.0f));
                        break;
                    }
                    case WEST: {
                        poseStack.translate(0.5, 0.5, 0.0);
                        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                    }
                }
                ((ModelIndustrialAlarm)RenderIndustrialAlarm.this.model).render(poseStack, buffer, 0xF000F0, overlayLight, 1.0f, 1.0f, 1.0f, 1.0f, rot);
                poseStack.popPose();
            }

            @Override
            @NotNull
            public Vec3 getCenterPos(float partialTick) {
                return tile.getBlockPos().getCenter();
            }

            @Override
            @NotNull
            public String getProfilerSection() {
                return "industrialAlarm";
            }

            @Override
            @NotNull
            public RenderType getRenderType() {
                return ((ModelIndustrialAlarm)RenderIndustrialAlarm.this.model).getRenderType();
            }
        });
    }

    @Override
    protected String getProfilerSection() {
        return "industrialAlarm";
    }

    public boolean shouldRender(TileEntityIndustrialAlarm tile, Vec3 camera) {
        return tile.getActive() && super.shouldRender((BlockEntity)tile, camera);
    }
}

