/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.model.MekanismModelCache;
import mekanism.client.render.RenderTickHandler;
import mekanism.client.render.lib.Outlines;
import mekanism.client.render.tileentity.IWireFrameRenderer;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.tile.machine.TileEntityPigmentMixer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class RenderPigmentMixer
extends MekanismTileEntityRenderer<TileEntityPigmentMixer>
implements IWireFrameRenderer {
    private static final float SHAFT_SPEED = 5.0f;
    @Nullable
    private static List<Outlines.Line> lines;

    public static void resetCached() {
        lines = null;
    }

    public RenderPigmentMixer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void render(TileEntityPigmentMixer tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        this.setupRenderer(tile, partialTick, matrix);
        PoseStack.Pose entry = matrix.last();
        VertexConsumer buffer = renderer.getBuffer(Sheets.solidBlockSheet());
        for (BakedQuad quad : MekanismModelCache.INSTANCE.PIGMENT_MIXER_SHAFT.getQuads(tile.getLevel().random)) {
            buffer.putBulkData(entry, quad, 1.0f, 1.0f, 1.0f, light, overlayLight);
        }
        matrix.popPose();
    }

    @Override
    protected String getProfilerSection() {
        return "pigmentMixer";
    }

    public boolean shouldRender(TileEntityPigmentMixer tile, Vec3 camera) {
        return tile.getActive() && super.shouldRender((BlockEntity)tile, camera);
    }

    @Override
    public boolean hasSelectionBox(BlockState state) {
        return Attribute.isActive(state);
    }

    @Override
    public boolean isCombined() {
        return true;
    }

    @Override
    public void renderWireFrame(BlockEntity tile, float partialTick, PoseStack matrix, VertexConsumer buffer) {
        if (tile instanceof TileEntityPigmentMixer) {
            TileEntityPigmentMixer mixer = (TileEntityPigmentMixer)tile;
            if (lines == null) {
                lines = Outlines.extract(MekanismModelCache.INSTANCE.PIGMENT_MIXER_SHAFT.getBakedModel(), null, tile.getLevel().random, ModelData.EMPTY, null);
            }
            this.setupRenderer(mixer, partialTick, matrix);
            PoseStack.Pose pose = matrix.last();
            RenderTickHandler.renderVertexWireFrame(lines, buffer, pose.pose(), pose.normal());
            matrix.popPose();
        }
    }

    private void setupRenderer(TileEntityPigmentMixer tile, float partialTick, PoseStack matrix) {
        matrix.pushPose();
        switch (tile.getDirection()) {
            case NORTH: {
                matrix.translate(0.4375f, 0.0f, 0.375f);
                break;
            }
            case SOUTH: {
                matrix.translate(0.4375f, 0.0f, 0.5f);
                break;
            }
            case WEST: {
                matrix.translate(0.375f, 0.0f, 0.4375f);
                break;
            }
            case EAST: {
                matrix.translate(0.5f, 0.0f, 0.4375f);
            }
        }
        float shift = 0.0625f;
        matrix.translate(shift, 0.0f, shift);
        matrix.mulPose(Axis.YN.rotationDegrees(((float)tile.getLevel().getGameTime() + partialTick) * 5.0f % 360.0f));
        matrix.translate(-shift, 0.0f, -shift);
    }

    public AABB getRenderBoundingBox(TileEntityPigmentMixer tile) {
        return new AABB(tile.getBlockPos().above());
    }
}

