/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.Map;
import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.functions.FloatSupplier;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.IBlastingItem;
import mekanism.common.content.gear.mekasuit.ModuleGravitationalModulatingUnit;
import mekanism.common.content.gear.mekasuit.ModuleHydraulicPropulsionUnit;
import mekanism.common.content.gear.mekasuit.ModuleHydrostaticRepulsorUnit;
import mekanism.common.content.gear.mekasuit.ModuleLocomotiveBoostingUnit;
import mekanism.common.item.gear.ItemFreeRunners;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.item.gear.ItemScubaMask;
import mekanism.common.item.gear.ItemScubaTank;
import mekanism.common.item.interfaces.IJetpackItem;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.registries.MekanismGameEvents;
import mekanism.common.registries.MekanismModules;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.entity.living.LivingAttackEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingHurtEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class CommonPlayerTickHandler {
    private static final float MIN_FALL_HURT = 3.0f;

    public static boolean isOnGroundOrSleeping(Player player) {
        return player.onGround() || player.isSleeping() || player.getAbilities().flying;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isScubaMaskOn(Player player, ItemStack tank) {
        ItemStack mask = player.getItemBySlot(EquipmentSlot.HEAD);
        if (tank.isEmpty()) return false;
        if (mask.isEmpty()) return false;
        Item item = tank.getItem();
        if (!(item instanceof ItemScubaTank)) return false;
        ItemScubaTank scubaTank = (ItemScubaTank)item;
        if (!(mask.getItem() instanceof ItemScubaMask)) return false;
        if (!ChemicalUtil.hasGas(tank)) return false;
        if ((Boolean)scubaTank.getMode(tank) == false) return false;
        return true;
    }

    public static float getStepBoost(Player player) {
        ItemFreeRunners freeRunners;
        if (player.isShiftKeyDown()) {
            return 0.0f;
        }
        ItemStack stack = player.getItemBySlot(EquipmentSlot.FEET);
        if (stack.isEmpty()) {
            return 0.0f;
        }
        Item item = stack.getItem();
        if (item instanceof ItemFreeRunners && ((ItemFreeRunners.FreeRunnerMode)(freeRunners = (ItemFreeRunners)item).getMode(stack)).providesStepBoost()) {
            return 0.5f;
        }
        IModule<ModuleHydraulicPropulsionUnit> hydraulic = IModuleHelper.INSTANCE.getIfEnabled(stack, MekanismModules.HYDRAULIC_PROPULSION_UNIT);
        return hydraulic != null ? hydraulic.getCustomInstance().getStepHeight() : 0.0f;
    }

    public static float getSwimBoost(Player player) {
        IModule<ModuleHydrostaticRepulsorUnit> swimModule = IModuleHelper.INSTANCE.getIfEnabled((LivingEntity)player, EquipmentSlot.LEGS, MekanismModules.HYDROSTATIC_REPULSOR_UNIT);
        return swimModule != null && swimModule.getCustomInstance().isSwimBoost(swimModule, player) ? 1.0f : 0.0f;
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side.isServer()) {
            this.tickEnd(event.player);
        }
    }

    private void tickEnd(Player player) {
        ItemStack chest;
        IJetpackItem jetpackItem;
        IJetpackItem.JetpackMode primaryMode;
        IJetpackItem.JetpackMode mode;
        ItemStack primaryJetpack;
        ItemStack jetpack;
        Mekanism.playerState.updateStepAssist(player);
        Mekanism.playerState.updateSwimBoost(player);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            RadiationManager.get().tickServer(serverPlayer);
        }
        if (!(jetpack = IJetpackItem.getActiveJetpack((LivingEntity)player)).isEmpty() && !(primaryJetpack = IJetpackItem.getPrimaryJetpack((LivingEntity)player)).isEmpty() && (mode = IJetpackItem.getPlayerJetpackMode(player, primaryMode = (jetpackItem = (IJetpackItem)primaryJetpack.getItem()).getJetpackMode(primaryJetpack), p -> Mekanism.keyMap.has(p.getUUID(), 0))) != IJetpackItem.JetpackMode.DISABLED) {
            double jetpackThrust = jetpackItem.getJetpackThrust(primaryJetpack);
            if (IJetpackItem.handleJetpackMotion(player, mode, jetpackThrust, p -> Mekanism.keyMap.has(p.getUUID(), 0))) {
                player.resetFallDistance();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.connection.aboveGroundTickCount = 0;
                }
            }
            ((IJetpackItem)jetpack.getItem()).useJetpackFuel(jetpack);
            if (player.level().getGameTime() % 10L == 0L) {
                player.gameEvent((GameEvent)MekanismGameEvents.JETPACK_BURN.get());
            }
        }
        if (CommonPlayerTickHandler.isScubaMaskOn(player, chest = player.getItemBySlot(EquipmentSlot.CHEST))) {
            ItemScubaTank tank = (ItemScubaTank)chest.getItem();
            int max = player.getMaxAirSupply();
            tank.useGas(chest, 1L);
            GasStack received = tank.useGas(chest, max - player.getAirSupply());
            if (!received.isEmpty()) {
                player.setAirSupply(player.getAirSupply() + (int)received.getAmount());
            }
            if (player.getAirSupply() == max) {
                for (MobEffectInstance effect : player.getActiveEffects()) {
                    if (!MekanismUtils.shouldSpeedUpEffect(effect)) continue;
                    for (int i = 0; i < 9; ++i) {
                        MekanismUtils.speedUpEffectSafely((LivingEntity)player, effect);
                    }
                }
            }
        }
    }

    public static boolean isGravitationalModulationReady(ItemStack stack) {
        IModule<ModuleGravitationalModulatingUnit> module = IModuleHelper.INSTANCE.getIfEnabled(stack, MekanismModules.GRAVITATIONAL_MODULATING_UNIT);
        return module != null && module.hasEnoughEnergy(MekanismConfig.gear.mekaSuitEnergyUsageGravitationalModulation);
    }

    public static boolean isGravitationalModulationOn(Player player) {
        return ModuleGravitationalModulatingUnit.shouldProcess(player) && CommonPlayerTickHandler.isGravitationalModulationReady(player.getItemBySlot(EquipmentSlot.CHEST));
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        Player player;
        ItemScubaTank tank;
        Item item;
        ItemStack chestStack;
        ItemStack headStack;
        LivingEntity entity = event.getEntity();
        if (event.getAmount() <= 0.0f || !entity.isAlive()) {
            return;
        }
        if (event.getSource().is(MekanismTags.DamageTypes.IS_PREVENTABLE_MAGIC) && !(headStack = entity.getItemBySlot(EquipmentSlot.HEAD)).isEmpty() && headStack.getItem() instanceof ItemScubaMask && !(chestStack = entity.getItemBySlot(EquipmentSlot.CHEST)).isEmpty() && (item = chestStack.getItem()) instanceof ItemScubaTank && ((Boolean)(tank = (ItemScubaTank)item).getMode(chestStack)).booleanValue() && ChemicalUtil.hasGas(chestStack)) {
            event.setCanceled(true);
            return;
        }
        if (entity instanceof Player && ItemMekaSuitArmor.tryAbsorbAll(player = (Player)entity, event.getSource(), event.getAmount())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        Player player;
        float ratioAbsorbed;
        LivingEntity entity = event.getEntity();
        if (event.getAmount() <= 0.0f || !entity.isAlive()) {
            return;
        }
        if (entity instanceof Player && (ratioAbsorbed = ItemMekaSuitArmor.getDamageAbsorbed(player = (Player)entity, event.getSource(), event.getAmount())) > 0.0f) {
            float damageRemaining = event.getAmount() * Math.max(0.0f, 1.0f - ratioAbsorbed);
            if (damageRemaining <= 0.0f) {
                event.setCanceled(true);
            } else {
                event.setAmount(damageRemaining);
            }
        }
    }

    @SubscribeEvent
    public void livingFall(LivingFallEvent event) {
        float fallDamage = Math.max(event.getDistance() - 3.0f, 0.0f);
        if (fallDamage <= 1.0E-5f) {
            return;
        }
        LivingEntity entity = event.getEntity();
        FallEnergyInfo info = this.getFallAbsorptionEnergyInfo(entity);
        if (info != null && info.container != null) {
            float absorption = info.damageRatio.getAsFloat();
            float amount = fallDamage * absorption;
            FloatingLong energyRequirement = info.energyCost.get().multiply(amount);
            float ratioAbsorbed = energyRequirement.isZero() ? absorption : absorption * info.container.extract(energyRequirement, Action.EXECUTE, AutomationType.MANUAL).divide(amount).floatValue();
            if (ratioAbsorbed > 0.0f) {
                float damageRemaining = fallDamage * Math.max(0.0f, 1.0f - ratioAbsorbed);
                if (damageRemaining <= 1.0E-5f) {
                    event.setCanceled(true);
                    SoundType soundtype = entity.getBlockStateOn().getSoundType((LevelReader)entity.level(), entity.getOnPos(), (Entity)entity);
                    entity.playSound(soundtype.getStepSound(), soundtype.getVolume() * 0.15f, soundtype.getPitch());
                } else {
                    event.setDistance(damageRemaining + 3.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        Player player;
        IModule<ModuleHydraulicPropulsionUnit> propulsionModule;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (propulsionModule = IModuleHelper.INSTANCE.getIfEnabled((LivingEntity)(player = (Player)livingEntity), EquipmentSlot.FEET, MekanismModules.HYDRAULIC_PROPULSION_UNIT)) != null && Mekanism.keyMap.has(player.getUUID(), 1)) {
            float boost = propulsionModule.getCustomInstance().getBoost();
            FloatingLong usage = ((FloatingLong)MekanismConfig.gear.mekaSuitBaseJumpEnergyUsage.get()).multiply(boost / 0.1f);
            if (propulsionModule.canUseEnergy((LivingEntity)player, usage)) {
                IModule<ModuleLocomotiveBoostingUnit> boostModule = IModuleHelper.INSTANCE.getIfEnabled((LivingEntity)player, EquipmentSlot.LEGS, MekanismModules.LOCOMOTIVE_BOOSTING_UNIT);
                if (boostModule != null && boostModule.getCustomInstance().canFunction(boostModule, player)) {
                    boost = Mth.sqrt((float)boost);
                }
                player.addDeltaMovement(new Vec3(0.0, (double)boost, 0.0));
                propulsionModule.useEnergy((LivingEntity)player, usage, true);
            }
        }
    }

    @Nullable
    private FallEnergyInfo getFallAbsorptionEnergyInfo(LivingEntity base) {
        ItemStack feetStack = base.getItemBySlot(EquipmentSlot.FEET);
        if (!feetStack.isEmpty()) {
            Item item = feetStack.getItem();
            if (item instanceof ItemFreeRunners) {
                ItemFreeRunners boots = (ItemFreeRunners)item;
                if (((ItemFreeRunners.FreeRunnerMode)boots.getMode(feetStack)).preventsFallDamage()) {
                    return new FallEnergyInfo(StorageUtils.getEnergyContainer(feetStack, 0), MekanismConfig.gear.freeRunnerFallDamageRatio, MekanismConfig.gear.freeRunnerFallEnergyCost);
                }
            } else if (feetStack.getItem() instanceof ItemMekaSuitArmor) {
                return new FallEnergyInfo(StorageUtils.getEnergyContainer(feetStack, 0), MekanismConfig.gear.mekaSuitFallDamageRatio, MekanismConfig.gear.mekaSuitEnergyUsageFall);
            }
        }
        return null;
    }

    @SubscribeEvent
    public void getBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        float speed = event.getNewSpeed();
        Optional position = event.getPosition();
        if (position.isPresent()) {
            IBlastingItem tool;
            Map<BlockPos, BlockState> blocks;
            Item item;
            BlockPos pos = (BlockPos)position.get();
            ItemStack mainHand = player.getMainHandItem();
            if (!mainHand.isEmpty() && (item = mainHand.getItem()) instanceof IBlastingItem && !(blocks = (tool = (IBlastingItem)item).getBlastedBlocks(player.level(), player, mainHand, pos, event.getState())).isEmpty()) {
                float targetHardness;
                float maxHardness = targetHardness = event.getState().getDestroySpeed((BlockGetter)player.level(), pos);
                for (Map.Entry<BlockPos, BlockState> entry : blocks.entrySet()) {
                    float destroySpeed = entry.getValue().getDestroySpeed((BlockGetter)player.level(), entry.getKey());
                    maxHardness = Math.max(maxHardness, destroySpeed);
                }
                speed *= targetHardness / maxHardness;
            }
        }
        if (IModuleHelper.INSTANCE.isEnabled(player.getItemBySlot(EquipmentSlot.LEGS), MekanismModules.GYROSCOPIC_STABILIZATION_UNIT)) {
            if (player.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value()) && !EnchantmentHelper.hasAquaAffinity((LivingEntity)player)) {
                speed *= 5.0f;
            }
            if (!player.onGround()) {
                speed *= 5.0f;
            }
        }
        event.setNewSpeed(speed);
    }

    private record FallEnergyInfo(@Nullable IEnergyContainer container, FloatSupplier damageRatio, FloatingLongSupplier energyCost) {
    }
}

