/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.advancements.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.registries.MekanismDamageTypes;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.NotNull;

public class MekanismDamageTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, MekanismDamageTypes.MekanismDamageType damageType, boolean hardcoreTotem) {
        this.trigger(player, instance -> {
            if (!instance.killed || player.isDeadOrDying() || hardcoreTotem) {
                return instance.damageType.key() == damageType.key();
            }
            return false;
        });
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, MekanismDamageTypes.MekanismDamageType damageType, boolean killed) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.strictOptionalField((Codec)EntityPredicate.ADVANCEMENT_CODEC, (String)"player").forGetter(TriggerInstance::player), (App)MekanismDamageTypes.CODEC.fieldOf("damage").forGetter(TriggerInstance::damageType), (App)Codec.BOOL.fieldOf("killed").forGetter(TriggerInstance::killed)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> damaged(MekanismDamageTypes.MekanismDamageType damageType) {
            return MekanismCriteriaTriggers.DAMAGE.createCriterion(new TriggerInstance(Optional.empty(), damageType, false));
        }

        public static Criterion<TriggerInstance> killed(MekanismDamageTypes.MekanismDamageType damageType) {
            return MekanismCriteriaTriggers.DAMAGE.createCriterion(new TriggerInstance(Optional.empty(), damageType, true));
        }
    }
}

