/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.RegistryUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class BlockData
implements INBTSerializable<CompoundTag> {
    private BlockState blockState;
    @Nullable
    private CompoundTag blockEntityTag;

    public static BlockData create(BlockState state, @Nullable BlockEntity blockEntity) {
        return new BlockData(state, blockEntity == null ? null : blockEntity.saveWithFullMetadata());
    }

    public static BlockData create() {
        return new BlockData(Blocks.AIR.defaultBlockState(), null);
    }

    private BlockData(BlockState state, @Nullable CompoundTag blockEntityTag) {
        this.blockState = state;
        this.blockEntityTag = blockEntityTag;
    }

    public boolean tryPlaceIntoWorld(Level level, BlockPos pos, @Nullable Player player) {
        BlockState adjustedState = Block.updateFromNeighbourShapes((BlockState)this.blockState, (LevelAccessor)level, (BlockPos)pos);
        if (adjustedState.isAir()) {
            return false;
        }
        FluidState fluidState = adjustedState.getFluidState();
        FluidType fluidType = fluidState.getFluidType();
        FluidStack fluid = new FluidStack(fluidState.getType(), 1000);
        BucketPickup tryPickup = null;
        if (fluidType.isVaporizedOnPlacement(level, pos, fluid)) {
            Block block;
            if (!MekanismConfig.general.strictUnboxing.get() && (block = adjustedState.getBlock()) instanceof BucketPickup) {
                BucketPickup pickup;
                tryPickup = pickup = (BucketPickup)block;
            } else {
                return false;
            }
        }
        level.setBlockAndUpdate(pos, adjustedState);
        if (this.blockEntityTag != null) {
            this.blockEntityTag.putInt("x", pos.getX());
            this.blockEntityTag.putInt("y", pos.getY());
            this.blockEntityTag.putInt("z", pos.getZ());
            BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)level, pos);
            if (tile != null) {
                tile.load(this.blockEntityTag);
            }
        }
        if (tryPickup != null && !tryPickup.pickupBlock(player, (LevelAccessor)level, pos, adjustedState).isEmpty()) {
            fluidType.onVaporize(null, level, pos, fluid);
        }
        return true;
    }

    public void addToTooltip(Consumer<Component> consumer) {
        Block block = this.blockState.getBlock();
        consumer.accept((Component)MekanismLang.BLOCK.translateColored(EnumColor.INDIGO, EnumColor.GRAY, block));
        if (this.blockEntityTag != null) {
            Optional blockEntityType = RegistryUtils.getById(this.blockEntityTag, BuiltInRegistries.BLOCK_ENTITY_TYPE);
            MekanismLang beName = blockEntityType.isPresent() ? RegistryUtils.getName((BlockEntityType)blockEntityType.get()) : MekanismLang.UNKNOWN;
            consumer.accept((Component)MekanismLang.BLOCK_ENTITY.translateColored(EnumColor.INDIGO, EnumColor.GRAY, beName));
            if (this.blockEntityTag != null) {
                DecoratedPotBlockEntity.Decorations decorations;
                if (block instanceof SpawnerBlock || block instanceof TrialSpawnerBlock) {
                    String key = block instanceof SpawnerBlock ? "SpawnData" : "spawn_data";
                    RegistryUtils.getById(this.blockEntityTag.getCompound(key).getCompound("entity"), BuiltInRegistries.ENTITY_TYPE).map(entity -> MekanismLang.BLOCK_ENTITY_SPAWN_TYPE.translateColored(EnumColor.INDIGO, EnumColor.GRAY, entity)).ifPresent(consumer);
                } else if (block instanceof DecoratedPotBlock && !(decorations = DecoratedPotBlockEntity.Decorations.load((CompoundTag)this.blockEntityTag)).equals((Object)DecoratedPotBlockEntity.Decorations.EMPTY)) {
                    consumer.accept((Component)MekanismLang.BLOCK_ENTITY_DECORATION.translateColored(EnumColor.INDIGO));
                    Stream.of(decorations.front(), decorations.left(), decorations.right(), decorations.back()).map(decoration -> MekanismLang.GENERIC_LIST.translateColored(EnumColor.INDIGO, EnumColor.GRAY, decoration)).forEach(consumer);
                }
            }
        }
    }

    public boolean isCompatible(BlockData other) {
        if (other == this) {
            return true;
        }
        return this.blockState == other.blockState && Objects.equals(this.blockEntityTag, other.blockEntityTag);
    }

    @Nullable
    public CompoundTag serializeNBT() {
        if (this.blockState.isAir()) {
            return null;
        }
        CompoundTag nbt = NbtUtils.writeBlockState((BlockState)this.blockState);
        if (this.blockEntityTag != null) {
            nbt.put("beTag", (Tag)this.blockEntityTag);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.blockState = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)nbt);
        NBTUtils.setCompoundIfPresent(nbt, "beTag", tag -> {
            this.blockEntityTag = tag;
        });
    }

    @Nullable
    public BlockData copy(IAttachmentHolder holder) {
        if (this.blockState.isAir()) {
            return null;
        }
        return new BlockData(this.blockState, this.blockEntityTag == null ? null : this.blockEntityTag.copy());
    }
}

