/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments;

import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongSortedMap;
import it.unimi.dsi.fastutil.objects.Object2LongSortedMaps;
import java.util.UUID;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.content.qio.QIODriveData;
import mekanism.common.content.qio.QIOGlobalItemLookup;
import mekanism.common.lib.inventory.HashedItem;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class DriveMetadata
implements INBTSerializable<CompoundTag> {
    private final Object2LongSortedMap<UUID> namedItemMap;
    private final Object2LongSortedMap<UUID> namedItemMapView;
    private long count;
    private int types;

    public static DriveMetadata create() {
        return new DriveMetadata(0L, 0, (Object2LongSortedMap<UUID>)new Object2LongLinkedOpenHashMap());
    }

    private DriveMetadata(long count, int types, Object2LongSortedMap<UUID> namedItemMap) {
        this.count = count;
        this.types = types;
        this.namedItemMap = namedItemMap;
        this.namedItemMapView = Object2LongSortedMaps.unmodifiable(this.namedItemMap);
    }

    public long count() {
        return this.count;
    }

    public int types() {
        return this.types;
    }

    public Object2LongMap<UUID> namedItemMap() {
        return this.namedItemMapView;
    }

    public void update(QIODriveData drive) {
        this.count = drive.getTotalCount();
        this.types = drive.getTotalTypes();
    }

    public void update(Object2LongMap<UUID> itemMap, long count) {
        this.count = count;
        this.types = itemMap.size();
        this.namedItemMap.clear();
        for (Object2LongMap.Entry entry : itemMap.object2LongEntrySet()) {
            this.namedItemMap.put((Object)((UUID)entry.getKey()), entry.getLongValue());
        }
    }

    public void copyItemMap(QIODriveData data) {
        this.namedItemMap.clear();
        for (Object2LongMap.Entry entry : data.getItemMap().object2LongEntrySet()) {
            this.namedItemMap.put((Object)QIOGlobalItemLookup.INSTANCE.getOrTrackUUID((HashedItem)entry.getKey()), entry.getLongValue());
        }
    }

    public void loadItemMap(QIODriveData data) {
        Object2LongMap<HashedItem> itemMap = data.getItemMap();
        for (Object2LongMap.Entry entry : this.namedItemMap.object2LongEntrySet()) {
            HashedItem type = QIOGlobalItemLookup.INSTANCE.getTypeByUUID((UUID)entry.getKey());
            if (type == null) continue;
            itemMap.put((Object)type, entry.getLongValue());
        }
    }

    public boolean isCompatible(DriveMetadata other) {
        return other == this || this.count == other.count && this.types == other.types && this.namedItemMap.equals(other.namedItemMap);
    }

    @Nullable
    public CompoundTag serializeNBT() {
        if (this.count == 0L && this.types == 0 && this.namedItemMap.isEmpty()) {
            return null;
        }
        CompoundTag nbt = new CompoundTag();
        if (this.count > 0L) {
            nbt.putLong("qioMetaCount", this.count);
        }
        if (this.types > 0) {
            nbt.putInt("qioMetaTypes", this.types);
        }
        if (!this.namedItemMap.isEmpty()) {
            nbt.putLongArray("qioItemMap", this.serializeItemMap());
        }
        return nbt;
    }

    private long[] serializeItemMap() {
        int i = 0;
        long[] serializedItemMap = new long[3 * this.namedItemMap.size()];
        for (Object2LongMap.Entry entry : this.namedItemMap.object2LongEntrySet()) {
            UUID uuid = (UUID)entry.getKey();
            serializedItemMap[i++] = uuid.getMostSignificantBits();
            serializedItemMap[i++] = uuid.getLeastSignificantBits();
            serializedItemMap[i++] = entry.getLongValue();
        }
        return serializedItemMap;
    }

    public void deserializeNBT(@NotNull CompoundTag nbt) {
        this.count = nbt.getLong("qioMetaCount");
        this.types = nbt.getInt("qioMetaTypes");
        this.readSerializedItemMap(nbt.getLongArray("qioItemMap"));
    }

    private void readSerializedItemMap(long[] serializedItemMap) {
        this.namedItemMap.clear();
        if (serializedItemMap.length > 0 && serializedItemMap.length % 3 == 0) {
            for (int i = 0; i < serializedItemMap.length; ++i) {
                this.namedItemMap.put((Object)new UUID(serializedItemMap[i++], serializedItemMap[i++]), serializedItemMap[i]);
            }
        }
    }

    @Nullable
    public DriveMetadata copy(IAttachmentHolder holder) {
        if (this.count == 0L && this.types == 0 && this.namedItemMap.isEmpty()) {
            return null;
        }
        return new DriveMetadata(this.count, this.types, (Object2LongSortedMap<UUID>)new Object2LongLinkedOpenHashMap(this.namedItemMap));
    }
}

