/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.FilterManager;
import mekanism.common.content.filter.IFilter;
import mekanism.common.lib.collection.HashList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class FilterAware
implements INBTSerializable<ListTag> {
    private final HashList<IFilter<?>> filters = new HashList();

    public void copyTo(FilterManager<?> filterManager) {
        filterManager.trySetFilters(this.filters);
    }

    public void copyFrom(FilterManager<?> filterManager) {
        this.filters.clear();
        this.filters.addAll(filterManager.getFilters());
    }

    private <FILTER extends IFilter<?>> Stream<FILTER> getEnabledStream(Class<FILTER> filterClass) {
        return this.filters.stream().filter(IFilter::isEnabled).filter(filterClass::isInstance).map(filterClass::cast);
    }

    public <FILTER extends IFilter<?>> List<FILTER> getEnabled(Class<FILTER> filterClass) {
        return this.getEnabledStream(filterClass).toList();
    }

    public <FILTER extends IFilter<?>> boolean anyEnabledMatch(Class<FILTER> filterClass, Predicate<FILTER> validator) {
        return this.getEnabledStream(filterClass).anyMatch(validator);
    }

    public boolean isCompatible(FilterAware other) {
        return other == this || this.filters.equals(other.filters);
    }

    @Nullable
    public ListTag serializeNBT() {
        if (this.filters.isEmpty()) {
            return null;
        }
        ListTag filterTags = new ListTag();
        for (IFilter<?> filter : this.filters) {
            filterTags.add((Object)filter.write(new CompoundTag()));
        }
        return filterTags;
    }

    public void deserializeNBT(ListTag tagList) {
        this.filters.clear();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            IFilter<?> filter = BaseFilter.readFromNBT(tagList.getCompound(i));
            if (filter == null) continue;
            this.filters.add(filter);
        }
    }

    @Nullable
    public FilterAware copy(IAttachmentHolder holder) {
        if (this.filters.isEmpty()) {
            return null;
        }
        FilterAware copy = new FilterAware();
        for (IFilter<?> filter : this.filters) {
            copy.filters.add((IFilter<?>)filter.clone());
        }
        return copy;
    }
}

