/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.item.ItemCraftingFormula;
import mekanism.common.registries.MekanismAttachmentTypes;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class FormulaAttachment
implements INBTSerializable<CompoundTag> {
    private final List<IInventorySlot> inventory = (List)Util.make(() -> {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < 9; ++i) {
            builder.add((Object)new ShallowInventorySlot());
        }
        return builder.build();
    });
    private boolean invalid;

    public static FormulaAttachment create(IAttachmentHolder attachmentHolder) {
        ItemStack stack;
        if (attachmentHolder instanceof ItemStack && (stack = (ItemStack)attachmentHolder).getItem() instanceof ItemCraftingFormula) {
            return new FormulaAttachment(false);
        }
        throw new IllegalArgumentException("Attempted to attach a formula to something other than a crafting formula item.");
    }

    public static Optional<FormulaAttachment> formula(ItemStack stack) {
        if (!stack.isEmpty() && stack.getItem() instanceof ItemCraftingFormula) {
            return Optional.of((FormulaAttachment)stack.getData(MekanismAttachmentTypes.FORMULA_HOLDER));
        }
        return Optional.empty();
    }

    public static Optional<FormulaAttachment> existingFormula(ItemStack stack) {
        if (!stack.isEmpty() && stack.getItem() instanceof ItemCraftingFormula) {
            return stack.getExistingData(MekanismAttachmentTypes.FORMULA_HOLDER);
        }
        return Optional.empty();
    }

    private FormulaAttachment(boolean invalid) {
        this.invalid = invalid;
    }

    public void setInvalid() {
        this.invalid = true;
    }

    public List<IInventorySlot> getItems() {
        return this.inventory;
    }

    public boolean isEmpty() {
        return this.inventory.stream().allMatch(IInventorySlot::isEmpty);
    }

    public boolean hasItems() {
        return this.inventory.stream().anyMatch(slot -> !slot.isEmpty());
    }

    public void setItems(NonNullList<ItemStack> items) {
        int slots = this.inventory.size();
        for (int i = 0; i < slots; ++i) {
            this.inventory.get(i).setStack(((ItemStack)items.get(i)).copyWithCount(1));
        }
        this.invalid = false;
    }

    public boolean isValid() {
        return !this.isInvalid();
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public boolean isCompatible(FormulaAttachment other) {
        if (other == this) {
            return true;
        }
        if (this.invalid != other.invalid) {
            return false;
        }
        int slots = this.inventory.size();
        for (int i = 0; i < slots; ++i) {
            if (this.inventory.get(i).isCompatible(other.inventory.get(i))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.invalid) {
            nbt.putBoolean("invalid", true);
        }
        ContainerType.ITEM.saveTo(nbt, this.inventory);
        return nbt.isEmpty() ? null : nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.invalid = nbt.getBoolean("invalid");
        ContainerType.ITEM.readFrom(nbt, this.inventory);
    }

    @Nullable
    public FormulaAttachment copy(IAttachmentHolder holder) {
        if (!this.invalid && this.inventory.stream().allMatch(IInventorySlot::isEmpty)) {
            return null;
        }
        FormulaAttachment copy = new FormulaAttachment(this.invalid);
        ContainerType.ITEM.copy(this.inventory, copy.inventory);
        return copy;
    }

    private static class ShallowInventorySlot
    extends BasicInventorySlot {
        private ShallowInventorySlot() {
            super(1, alwaysTrueBi, alwaysTrueBi, alwaysTrue, null, 0, 0);
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            this.setStackUnchecked(ItemStack.of((CompoundTag)nbt));
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            if (!this.isEmpty()) {
                this.current.save(nbt);
            }
            return nbt;
        }
    }
}

