/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.security.IItemSecurityUtils;
import mekanism.api.security.SecurityMode;
import mekanism.common.item.interfaces.IColoredItem;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IColorableFrequency;
import mekanism.common.lib.frequency.IFrequencyItem;
import mekanism.common.lib.frequency.TileComponentFrequency;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.lib.security.SecurityUtils;
import mekanism.common.registries.MekanismAttachmentTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class FrequencyAware<FREQ extends Frequency>
implements INBTSerializable<CompoundTag> {
    private final FrequencyType<FREQ> frequencyType;
    private final ItemStack attachmentHolder;
    @Nullable
    private Frequency.FrequencyIdentity identity;
    @Nullable
    private FREQ frequency;

    public static FrequencyAware<?> create(IAttachmentHolder holder) {
        Item item;
        ItemStack stack;
        if (holder instanceof ItemStack && !(stack = (ItemStack)holder).isEmpty() && (item = stack.getItem()) instanceof IFrequencyItem) {
            IFrequencyItem frequencyItem = (IFrequencyItem)item;
            return new FrequencyAware(stack, frequencyItem.getFrequencyType());
        }
        throw new IllegalArgumentException("Attempted to attach frequency awareness to an object that does not support frequencies.");
    }

    private FrequencyAware(ItemStack stack, FrequencyType<FREQ> frequencyType) {
        this(stack, frequencyType, null, null);
    }

    private FrequencyAware(ItemStack attachmentHolder, FrequencyType<FREQ> frequencyType, @Nullable Frequency.FrequencyIdentity identity, @Nullable FREQ frequency) {
        this.attachmentHolder = attachmentHolder;
        this.frequencyType = frequencyType;
        this.frequency = frequency;
        this.identity = identity;
    }

    @Nullable
    public UUID getOwner() {
        return this.identity == null ? null : this.identity.ownerUUID();
    }

    @Nullable
    public Frequency.FrequencyIdentity getIdentity() {
        return this.identity;
    }

    public FrequencyType<FREQ> getFrequencyType() {
        return this.frequencyType;
    }

    @Nullable
    public FREQ getFrequency() {
        SecurityFrequency security;
        UUID ownerUUID;
        if (this.frequency != null && ((Frequency)this.frequency).getSecurity() == SecurityMode.TRUSTED && EffectiveSide.get().isServer() && (ownerUUID = IItemSecurityUtils.INSTANCE.getOwnerUUID(this.attachmentHolder)) != null && !((Frequency)this.frequency).ownerMatches(ownerUUID) && (security = FrequencyType.SECURITY.getManager(null, SecurityMode.PUBLIC).getFrequency(((Frequency)this.frequency).getOwner())) != null && !security.isTrusted(ownerUUID)) {
            this.setFrequency(null);
        }
        return this.frequency;
    }

    public void setFrequency(Frequency.FrequencyIdentity data, UUID player) {
        FrequencyManager<FREQ> manager;
        FREQ freq = null;
        if (!Objects.equals(data.ownerUUID(), player) && SecurityUtils.get().isTrusted(data.securityMode(), data.ownerUUID(), player) && (freq = (FREQ)(manager = this.frequencyType.getManager(data, data.ownerUUID())).getFrequency(data.key())) == null) {
            data = new Frequency.FrequencyIdentity(data.key(), data.securityMode(), player);
        }
        if (freq == null) {
            manager = this.frequencyType.getManager(data, player);
            freq = manager.getOrCreateFrequency(data, player);
        }
        this.setFrequency(freq);
    }

    public void removeFrequency(Frequency.FrequencyIdentity data, UUID player) {
        Frequency.FrequencyIdentity current;
        FrequencyManager<FREQ> manager = this.frequencyType.getManager(data, data.ownerUUID() == null ? player : data.ownerUUID());
        if (manager.remove(data.key(), player) && (current = this.getIdentity()) != null && current.equals(data)) {
            this.setFrequency(null);
        }
    }

    public void setFrequency(@Nullable FREQ frequency) {
        this.frequency = frequency;
        Frequency.FrequencyIdentity frequencyIdentity = this.identity = this.frequency == null ? null : ((Frequency)this.frequency).getIdentity();
        if (IColoredItem.supports((IAttachmentHolder)this.attachmentHolder)) {
            if (this.frequency == null) {
                this.attachmentHolder.removeData(MekanismAttachmentTypes.COLORABLE);
            } else {
                this.attachmentHolder.setData(MekanismAttachmentTypes.COLORABLE, Optional.of(((IColorableFrequency)this.frequency).getColor()));
            }
        }
    }

    public void copyFrom(TileComponentFrequency component) {
        this.setFrequency(component.getFrequency(this.frequencyType));
    }

    public boolean isCompatible(FrequencyAware<?> other) {
        if (other == this) {
            return true;
        }
        if (this.frequency == null) {
            return other.frequency == null;
        }
        if (other.frequency == null) {
            return false;
        }
        return Objects.equals(this.identity, other.identity);
    }

    @Nullable
    public CompoundTag serializeNBT() {
        if (this.frequency == null) {
            return this.identity == null ? null : this.frequencyType.getIdentitySerializer().serialize(this.identity);
        }
        return ((Frequency)this.frequency).serializeIdentityWithOwner();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.identity = Frequency.FrequencyIdentity.load(this.frequencyType, nbt);
        if (this.identity != null && EffectiveSide.get().isServer()) {
            this.frequency = this.frequencyType.getManager(this.identity, this.identity.ownerUUID()).getFrequency(this.identity.key());
        }
    }

    @Nullable
    public FrequencyAware<FREQ> copy(IAttachmentHolder holder) {
        IFrequencyItem frequencyItem;
        Item item;
        ItemStack stack;
        if (this.frequency == null && this.identity == null) {
            return null;
        }
        if (holder instanceof ItemStack && !(stack = (ItemStack)holder).isEmpty() && (item = stack.getItem()) instanceof IFrequencyItem && (frequencyItem = (IFrequencyItem)item).getFrequencyType() == this.frequencyType) {
            return new FrequencyAware<FREQ>(stack, this.frequencyType, this.identity, this.frequency);
        }
        return null;
    }
}

