/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.lib.inventory.HashedItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class OverflowAware
implements INBTSerializable<ListTag> {
    private final Object2IntSortedMap<HashedItem> overflow;

    public static OverflowAware create() {
        return new OverflowAware((Object2IntSortedMap<HashedItem>)new Object2IntLinkedOpenHashMap());
    }

    private OverflowAware(Object2IntSortedMap<HashedItem> overflow) {
        this.overflow = overflow;
    }

    public Object2IntMap<HashedItem> getOverflow() {
        return this.overflow;
    }

    public void setOverflow(Object2IntMap<HashedItem> overflow) {
        this.overflow.clear();
        this.overflow.putAll(overflow);
    }

    public boolean isCompatible(OverflowAware other) {
        return other == this || this.overflow.equals(other.overflow);
    }

    @Nullable
    public ListTag serializeNBT() {
        return this.overflow.isEmpty() ? null : OverflowAware.writeOverflow(this.overflow);
    }

    public void deserializeNBT(ListTag overflowTag) {
        this.overflow.clear();
        OverflowAware.readOverflow(this.overflow, overflowTag);
    }

    @Nullable
    public OverflowAware copy(IAttachmentHolder holder) {
        if (this.overflow.isEmpty()) {
            return null;
        }
        return new OverflowAware((Object2IntSortedMap<HashedItem>)new Object2IntLinkedOpenHashMap(this.overflow));
    }

    public static ListTag writeOverflow(Object2IntMap<HashedItem> overflow) {
        ListTag overflowTag = new ListTag();
        for (Object2IntMap.Entry entry : overflow.object2IntEntrySet()) {
            CompoundTag overflowComponent = new CompoundTag();
            overflowComponent.put("type", (Tag)((HashedItem)entry.getKey()).internalToNBT());
            overflowComponent.putInt("Count", entry.getIntValue());
            overflowTag.add((Object)overflowComponent);
        }
        return overflowTag;
    }

    public static void readOverflow(Object2IntMap<HashedItem> overflow, ListTag overflowTag) {
        int size = overflowTag.size();
        for (int i = 0; i < size; ++i) {
            ItemStack s;
            CompoundTag overflowComponent = overflowTag.getCompound(i);
            int count = overflowComponent.getInt("Count");
            if (count <= 0 || (s = ItemStack.of((CompoundTag)overflowComponent.getCompound("type"))).isEmpty()) continue;
            overflow.put((Object)HashedItem.raw(s), count);
        }
    }
}

