/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.attachments.FrequencyAware;
import mekanism.common.content.qio.IQIOCraftingWindowHolder;
import mekanism.common.content.qio.QIOCraftingWindow;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.slot.CraftingWindowInventorySlot;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismItems;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import org.jetbrains.annotations.Nullable;

public class PortableQIODashboardInventory
implements IQIOCraftingWindowHolder {
    private final QIOCraftingWindow[] craftingWindows;
    private final List<IInventorySlot> slots;
    private final ItemStack stack;
    @Nullable
    private Level level;

    public static PortableQIODashboardInventory create(IAttachmentHolder holder) {
        ItemStack stack;
        if (holder instanceof ItemStack && !(stack = (ItemStack)holder).isEmpty() && (stack.is(MekanismItems.PORTABLE_QIO_DASHBOARD) || stack.is((Item)MekanismBlocks.QIO_DASHBOARD.asItem()))) {
            return new PortableQIODashboardInventory(stack);
        }
        throw new IllegalArgumentException("Attempted to attach a QIO Dashboard to an object that doesn't support them.");
    }

    private PortableQIODashboardInventory(ItemStack stack) {
        this.stack = stack;
        ArrayList<CraftingWindowInventorySlot> slots = new ArrayList<CraftingWindowInventorySlot>();
        this.craftingWindows = new QIOCraftingWindow[3];
        for (int tableIndex = 0; tableIndex < this.craftingWindows.length; ++tableIndex) {
            QIOCraftingWindow craftingWindow;
            this.craftingWindows[tableIndex] = craftingWindow = new QIOCraftingWindow(this, (byte)tableIndex);
            for (int slot = 0; slot < 9; ++slot) {
                slots.add(craftingWindow.getInputSlot(slot));
            }
            slots.add(craftingWindow.getOutputSlot());
        }
        this.slots = List.copyOf(slots);
    }

    public PortableQIODashboardInventory updateLevel(@Nullable Level level) {
        this.level = level;
        for (QIOCraftingWindow craftingWindow : this.craftingWindows) {
            craftingWindow.invalidateRecipe();
        }
        return this;
    }

    public List<IInventorySlot> getSlots() {
        return this.slots;
    }

    @Override
    @Nullable
    public Level getLevel() {
        return this.level;
    }

    @Override
    public QIOCraftingWindow[] getCraftingWindows() {
        return this.craftingWindows;
    }

    @Override
    @Nullable
    public QIOFrequency getFrequency() {
        Object frequency;
        if (this.level != null && !this.level.isClientSide() && !this.stack.isEmpty() && (frequency = ((FrequencyAware)this.stack.getData(MekanismAttachmentTypes.FREQUENCY_AWARE)).getFrequency()) instanceof QIOFrequency) {
            QIOFrequency freq = (QIOFrequency)frequency;
            return freq;
        }
        return null;
    }

    @Override
    public void onContentsChanged() {
    }
}

