/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.component;

import java.util.Arrays;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.EnumColor;
import mekanism.common.attachments.component.IAttachedComponent;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.util.EnumUtils;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class AttachedEjector
implements IAttachedComponent<TileComponentEjector> {
    private final EnumColor[] inputColors;
    private boolean strictInput;
    @Nullable
    private EnumColor outputColor;

    public static AttachedEjector create() {
        return new AttachedEjector(new EnumColor[EnumUtils.SIDES.length], false, null);
    }

    private AttachedEjector(EnumColor[] inputColors, boolean strictInput, @Nullable EnumColor outputColor) {
        this.inputColors = inputColors;
        this.strictInput = strictInput;
        this.outputColor = outputColor;
    }

    public boolean isCompatible(AttachedEjector other) {
        if (other == this) {
            return true;
        }
        return this.strictInput == other.strictInput && this.outputColor == other.outputColor && Arrays.equals(this.inputColors, other.inputColors);
    }

    @Nullable
    public CompoundTag serializeNBT() {
        CompoundTag ejectorNBT = TileComponentEjector.serialize(this.strictInput, this.inputColors, this.outputColor);
        return ejectorNBT.isEmpty() ? null : ejectorNBT;
    }

    public void deserializeNBT(CompoundTag ejectorNBT) {
        TileComponentEjector.deserialize(ejectorNBT, strict -> {
            this.strictInput = strict;
        }, output -> {
            this.outputColor = output;
        }, this.inputColors);
    }

    @Nullable
    public AttachedEjector copy(IAttachmentHolder holder) {
        if (!this.strictInput && this.outputColor == null && Arrays.stream(this.inputColors).allMatch(Objects::isNull)) {
            return null;
        }
        return new AttachedEjector(Arrays.copyOf(this.inputColors, this.inputColors.length), this.strictInput, this.outputColor);
    }
}

