/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.component;

import java.util.Objects;
import java.util.Set;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.attachments.FrequencyAware;
import mekanism.common.attachments.component.IAttachedComponent;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IFrequencyItem;
import mekanism.common.lib.frequency.TileComponentFrequency;
import mekanism.common.registries.MekanismAttachmentTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class AttachedFrequencyComponent
implements IAttachedComponent<TileComponentFrequency> {
    private final ItemStack stack;
    @Nullable
    private CompoundTag frequencyNBT;

    public AttachedFrequencyComponent(IAttachmentHolder attachmentHolder) {
        this(attachmentHolder, null);
    }

    private AttachedFrequencyComponent(IAttachmentHolder attachmentHolder, @Nullable CompoundTag frequencyNBT) {
        ItemStack itemStack;
        this.stack = attachmentHolder instanceof ItemStack ? (itemStack = (ItemStack)attachmentHolder) : ItemStack.EMPTY;
        this.frequencyNBT = frequencyNBT;
    }

    public boolean isCompatible(AttachedFrequencyComponent other) {
        return other == this || Objects.equals(this.frequencyNBT, other.frequencyNBT);
    }

    @Override
    public void copyFrom(TileComponentFrequency component) {
        Set<FrequencyType<?>> customFrequencies = component.getCustomFrequencies();
        if (!customFrequencies.isEmpty()) {
            IFrequencyItem frequencyItem;
            CompoundTag serializedComponent = component.serialize();
            if (serializedComponent.contains(FrequencyType.SECURITY.getName(), 10)) {
                serializedComponent.remove(FrequencyType.SECURITY.getName());
            }
            this.deserializeNBT(serializedComponent);
            Item item = this.stack.getItem();
            if (item instanceof IFrequencyItem && customFrequencies.contains((frequencyItem = (IFrequencyItem)item).getFrequencyType())) {
                ((FrequencyAware)this.stack.getData(MekanismAttachmentTypes.FREQUENCY_AWARE)).copyFrom(component);
            }
        }
    }

    @Nullable
    public CompoundTag serializeNBT() {
        if (this.frequencyNBT == null || this.frequencyNBT.isEmpty()) {
            return null;
        }
        return this.frequencyNBT;
    }

    public void deserializeNBT(CompoundTag frequencyNBT) {
        this.frequencyNBT = frequencyNBT.isEmpty() ? null : frequencyNBT;
    }

    @Nullable
    public AttachedFrequencyComponent copy(IAttachmentHolder holder) {
        if (this.frequencyNBT == null || this.frequencyNBT.isEmpty()) {
            return null;
        }
        return new AttachedFrequencyComponent(holder, this.frequencyNBT.copy());
    }
}

