/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.component;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import mekanism.api.RelativeSide;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.attachments.component.IAttachedComponent;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeSideConfig;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.IPersistentConfigInfo;
import mekanism.common.util.EnumUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class AttachedSideConfig
implements IAttachedComponent<TileComponentConfig> {
    private final Map<TransmissionType, LightConfigInfo> configInfo;

    public static AttachedSideConfig create(IAttachmentHolder attachmentHolder) {
        BlockItem blockItem;
        AttributeSideConfig sideConfig;
        Item item;
        ItemStack stack;
        if (attachmentHolder instanceof ItemStack && !(stack = (ItemStack)attachmentHolder).isEmpty() && (item = stack.getItem()) instanceof BlockItem && (sideConfig = Attribute.get((blockItem = (BlockItem)item).getBlock(), AttributeSideConfig.class)) != null) {
            return new AttachedSideConfig(sideConfig.supportedTypes());
        }
        throw new IllegalArgumentException("Attempted to attach side config awareness to an object that does not support having a side config.");
    }

    @Nullable
    public static IPersistentConfigInfo getStoredConfigInfo(ItemStack stack, TransmissionType transmissionType) {
        Optional existingData = stack.getExistingData(MekanismAttachmentTypes.SIDE_CONFIG);
        if (existingData.isEmpty()) {
            return null;
        }
        LightConfigInfo config = ((AttachedSideConfig)existingData.get()).configInfo.get(transmissionType);
        return config.sideConfig.isEmpty() ? null : config;
    }

    private AttachedSideConfig(Set<TransmissionType> types) {
        this(new EnumMap<TransmissionType, LightConfigInfo>(TransmissionType.class));
        for (TransmissionType type : types) {
            this.configInfo.put(type, new LightConfigInfo());
        }
    }

    private AttachedSideConfig(Map<TransmissionType, LightConfigInfo> configInfo) {
        this.configInfo = configInfo;
    }

    public boolean isCompatible(AttachedSideConfig other) {
        return other == this || this.configInfo.equals(other.configInfo);
    }

    @Nullable
    public IPersistentConfigInfo getConfig(TransmissionType transmissionType) {
        return this.configInfo.get(transmissionType);
    }

    @Nullable
    public CompoundTag serializeNBT() {
        CompoundTag configNBT = new CompoundTag();
        for (Map.Entry<TransmissionType, LightConfigInfo> entry : this.configInfo.entrySet()) {
            TransmissionType type = entry.getKey();
            LightConfigInfo info = entry.getValue();
            if (info.ejecting != null) {
                configNBT.putBoolean("eject" + type.ordinal(), info.isEjecting());
            }
            if (info.sideConfig.isEmpty()) continue;
            int[] sideData = new int[EnumUtils.SIDES.length];
            for (int i = 0; i < EnumUtils.SIDES.length; ++i) {
                sideData[i] = info.getDataType(EnumUtils.SIDES[i]).ordinal();
            }
            configNBT.putIntArray("config" + type.ordinal(), sideData);
        }
        return configNBT.isEmpty() ? null : configNBT;
    }

    public void deserializeNBT(CompoundTag configNBT) {
        TileComponentConfig.read(configNBT, this.configInfo);
    }

    @Nullable
    public AttachedSideConfig copy(IAttachmentHolder holder) {
        boolean hasData = false;
        EnumMap<TransmissionType, LightConfigInfo> sideConfigCopy = new EnumMap<TransmissionType, LightConfigInfo>(TransmissionType.class);
        for (Map.Entry<TransmissionType, LightConfigInfo> entry : this.configInfo.entrySet()) {
            LightConfigInfo info = entry.getValue();
            LightConfigInfo infoCopy = new LightConfigInfo();
            sideConfigCopy.put(entry.getKey(), infoCopy);
            if (info.ejecting == null && info.sideConfig.isEmpty()) continue;
            infoCopy.ejecting = info.ejecting;
            infoCopy.sideConfig.putAll(info.sideConfig);
            hasData = true;
        }
        return hasData ? new AttachedSideConfig(sideConfigCopy) : null;
    }

    private static class LightConfigInfo
    implements IPersistentConfigInfo {
        private final Map<RelativeSide, DataType> sideConfig = new EnumMap<RelativeSide, DataType>(RelativeSide.class);
        @Nullable
        private Boolean ejecting;

        @Override
        @NotNull
        public DataType getDataType(@NotNull RelativeSide side) {
            return this.sideConfig.getOrDefault(side, DataType.NONE);
        }

        @Override
        public boolean setDataType(@NotNull DataType dataType, @NotNull RelativeSide side) {
            return this.sideConfig.put(side, dataType) != dataType;
        }

        @Override
        public boolean isEjecting() {
            return this.ejecting != null && this.ejecting != false;
        }

        @Override
        public void setEjecting(boolean ejecting) {
            this.ejecting = ejecting;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            LightConfigInfo other = (LightConfigInfo)object;
            return Objects.equals(this.ejecting, other.ejecting) && Objects.equals(this.sideConfig, other.sideConfig);
        }

        public int hashCode() {
            return Objects.hash(this.sideConfig, this.ejecting);
        }
    }
}

