/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.component;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.common.attachments.component.IAttachedComponent;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.inventory.slot.UpgradeInventorySlot;
import mekanism.common.tile.component.TileComponentUpgrade;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class UpgradeAware
implements IMekanismInventory,
IAttachedComponent<TileComponentUpgrade> {
    private final Map<Upgrade, Integer> upgrades = new EnumMap<Upgrade, Integer>(Upgrade.class);
    private final Set<Upgrade> supportedUpgrades;
    private final List<IInventorySlot> upgradeSlots;

    public static UpgradeAware create(IAttachmentHolder attachmentHolder) {
        UpgradeAware upgradeAware = UpgradeAware.createInternal(attachmentHolder);
        if (upgradeAware == null) {
            throw new IllegalArgumentException("Attempted to attach upgrade awareness to an object that does not support upgrades.");
        }
        return upgradeAware;
    }

    @Nullable
    private static UpgradeAware createInternal(IAttachmentHolder attachmentHolder) {
        BlockItem blockItem;
        AttributeUpgradeSupport upgradeSupport;
        Item item;
        ItemStack stack;
        if (attachmentHolder instanceof ItemStack && !(stack = (ItemStack)attachmentHolder).isEmpty() && (item = stack.getItem()) instanceof BlockItem && (upgradeSupport = Attribute.get((blockItem = (BlockItem)item).getBlock(), AttributeUpgradeSupport.class)) != null) {
            return new UpgradeAware(upgradeSupport.supportedUpgrades());
        }
        return null;
    }

    private UpgradeAware(Set<Upgrade> supportedUpgrades) {
        this.supportedUpgrades = supportedUpgrades;
        this.upgradeSlots = List.of(UpgradeInventorySlot.input(null, this.supportedUpgrades), UpgradeInventorySlot.output(null));
    }

    public Set<Upgrade> getSupportedUpgrades() {
        return this.supportedUpgrades;
    }

    public Map<Upgrade, Integer> getUpgrades() {
        return this.upgrades;
    }

    public void setUpgrades(Map<Upgrade, Integer> upgrades) {
        this.upgrades.clear();
        this.upgrades.putAll(upgrades);
    }

    public int getUpgradeCount(Upgrade upgrade) {
        return this.upgrades.getOrDefault(upgrade, 0);
    }

    public boolean isCompatible(UpgradeAware other) {
        if (other == this) {
            return true;
        }
        if (!this.upgrades.equals(other.upgrades)) {
            return false;
        }
        int slots = this.upgradeSlots.size();
        for (int i = 0; i < slots; ++i) {
            if (this.upgradeSlots.get(i).isCompatible(other.upgradeSlots.get(i))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public CompoundTag serializeNBT() {
        CompoundTag upgradeNBT = new CompoundTag();
        if (!this.upgrades.isEmpty()) {
            Upgrade.saveMap(this.upgrades, upgradeNBT);
        }
        ContainerType.ITEM.saveTo(upgradeNBT, this.upgradeSlots);
        return upgradeNBT.isEmpty() ? null : upgradeNBT;
    }

    public void deserializeNBT(CompoundTag upgradeNBT) {
        this.setUpgrades(Upgrade.buildMap(upgradeNBT));
        ContainerType.ITEM.readFrom(upgradeNBT, this.upgradeSlots);
    }

    @Nullable
    public UpgradeAware copy(IAttachmentHolder holder) {
        if (this.upgrades.isEmpty() && this.upgradeSlots.stream().allMatch(IInventorySlot::isEmpty)) {
            return null;
        }
        UpgradeAware copy = UpgradeAware.createInternal(holder);
        if (copy != null) {
            copy.upgrades.putAll(this.upgrades);
            ContainerType.ITEM.copy(this.upgradeSlots, copy.upgradeSlots);
        }
        return copy;
    }

    @Override
    public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return this.upgradeSlots;
    }

    @Override
    public void onContentsChanged() {
    }
}

